/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.menu;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.entity.stormlighttrader.IStormlightTrader;

public class StormlightTraderContainer
implements Container {
    private final IStormlightTrader trader;
    private final NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int stormlight;

    public StormlightTraderContainer(IStormlightTrader pTrader) {
        this.trader = pTrader;
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.itemStacks.get(pSlot);
    }

    @NotNull
    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack stack = (ItemStack)this.itemStacks.get(pSlot);
        if (pSlot == 3 && !stack.m_41619_()) {
            return ContainerHelper.m_18969_(this.itemStacks, (int)pSlot, (int)stack.m_41613_());
        }
        stack = ContainerHelper.m_18969_(this.itemStacks, (int)pSlot, (int)pAmount);
        if (!stack.m_41619_() && this.isPaymentSlot(pSlot)) {
            this.updateSellItem();
        }
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.itemStacks, (int)pSlot);
    }

    public void m_6836_(int pSlot, @NotNull ItemStack pStack) {
        this.itemStacks.set(pSlot, (Object)pStack);
        if (!pStack.m_41619_() && pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (this.isPaymentSlot(pSlot)) {
            this.updateSellItem();
        }
    }

    public void m_6596_() {
        this.updateSellItem();
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return this.trader.getTradingPlayer() == pPlayer;
    }

    public void m_6211_() {
        this.itemStacks.clear();
    }

    private boolean isPaymentSlot(int pSlot) {
        return pSlot < 3;
    }

    public void updateSellItem() {
        this.stormlight = 0;
        for (int i = 0; i < 3; ++i) {
            this.stormlight += StormlightStorageHelper.getStormlight((ICapabilityProvider)this.itemStacks.get(i));
        }
        if (this.stormlight >= this.trader.getTradeCost()) {
            this.m_6836_(3, this.trader.getTradeItem().m_41777_());
        } else {
            this.m_6836_(3, ItemStack.f_41583_);
        }
    }

    public int getStormlight() {
        return this.stormlight;
    }
}

