/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.sound.StormwardSoundEvents;
import us.amon.stormward.weather.Highstorm;
import us.amon.stormward.worldgen.biome.StormwardBiomes;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Unique
    private boolean stormward$isRainInRosharanBiome;
    @Shadow
    private int f_109477_;
    @Shadow
    @Final
    private final float[] f_109451_ = new float[1024];
    @Shadow
    @Final
    private final float[] f_109452_ = new float[1024];
    @Shadow
    @Final
    private Minecraft f_109461_;

    @Shadow
    public static int m_109541_(BlockAndTintGetter pLevel, BlockPos pPos) {
        return 0;
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="net.minecraft.world.level.biome.Biome.getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onGetPrecipitationAt(LightTexture pLightTexture, float pPartialTick, double pCamX, double pCamY, double pCamZ, CallbackInfo ci, float f, Level level, int i, int j, int k, Tesselator tesselator, BufferBuilder bufferbuilder, int l, int i1, float f1, BlockPos.MutableBlockPos blockpos$mutableblockpos, int j1, int k1, int l1, double d0, double d1, Biome biome, int i2, int j2, int k2, int l2, RandomSource randomsource) {
        this.stormward$isRainInRosharanBiome = StormwardBiomes.isRosharanBiome((Holder<Biome>)level.m_204166_((BlockPos)blockpos$mutableblockpos));
    }

    @ModifyVariable(method={"renderSnowAndRain"}, at=@At(value="STORE"))
    private Biome.Precipitation injected(Biome.Precipitation value) {
        if (this.stormward$isRainInRosharanBiome) {
            return Biome.Precipitation.NONE;
        }
        return value;
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="net.minecraft.core.BlockPos$MutableBlockPos.<init>()V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void beforeSnowAndRainTesselation(LightTexture pLightTexture, float pPartialTick, double pCamX, double pCamY, double pCamZ, CallbackInfo ci, float f, Level level, int i, int j, int k, Tesselator tesselator, BufferBuilder bufferbuilder, int l, int i1, float f1) {
        boolean highstorming = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = k - l; j1 <= k + l; ++j1) {
            for (int k1 = i - l; k1 <= i + l; ++k1) {
                int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                double d0 = (double)this.f_109451_[l1] * 0.5;
                double d1 = (double)this.f_109452_[l1] * 0.5;
                blockpos$mutableblockpos.m_122169_((double)k1, pCamY, (double)j1);
                Biome biome = (Biome)level.m_204166_((BlockPos)blockpos$mutableblockpos).m_203334_();
                if (!biome.m_264473_()) continue;
                int i2 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                int j2 = j - l;
                int k2 = j + l;
                if (j2 < i2) {
                    j2 = i2;
                }
                if (k2 < i2) {
                    k2 = i2;
                }
                int l2 = i2;
                if (i2 < j) {
                    l2 = j;
                }
                if (j2 == k2) continue;
                RandomSource randomsource = RandomSource.m_216335_((long)((long)k1 * (long)k1 * 3121L + (long)k1 * 45238971L ^ (long)j1 * (long)j1 * 418711L + (long)j1 * 13761L));
                blockpos$mutableblockpos.m_122178_(k1, j2, j1);
                if (!StormwardBiomes.isRosharanBiome((Holder<Biome>)level.m_204166_((BlockPos)blockpos$mutableblockpos))) continue;
                if (!highstorming) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)Highstorm.RESOURCE);
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                    highstorming = true;
                }
                int i3 = this.f_109477_ + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                float f2 = -((float)i3 + pPartialTick) / 32.0f * (3.0f + randomsource.m_188501_());
                double d2 = (double)k1 + 0.5 - pCamX;
                double d4 = (double)j1 + 0.5 - pCamZ;
                float f3 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                blockpos$mutableblockpos.m_122178_(k1, l2, j1);
                int j3 = LevelRendererMixin.m_109541_((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                bufferbuilder.m_5483_((double)k1 - pCamX - d0 + 0.5 + 2.68, (double)k2 - pCamY, (double)j1 - pCamZ - d1 + 0.5).m_7421_(0.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                bufferbuilder.m_5483_((double)k1 - pCamX + d0 + 0.5 + 2.68, (double)k2 - pCamY, (double)j1 - pCamZ + d1 + 0.5).m_7421_(1.0f, (float)j2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                bufferbuilder.m_5483_((double)k1 - pCamX + d0 + 0.5 - 1.32, (double)j2 - pCamY, (double)j1 - pCamZ + d1 + 0.5).m_7421_(1.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
                bufferbuilder.m_5483_((double)k1 - pCamX - d0 + 0.5 - 1.32, (double)j2 - pCamY, (double)j1 - pCamZ - d1 + 0.5).m_7421_(0.0f, (float)k2 * 0.25f + f2).m_85950_(1.0f, 1.0f, 1.0f, f4).m_85969_(j3).m_5752_();
            }
        }
        if (highstorming) {
            tesselator.m_85914_();
        }
    }

    @Inject(method={"tickRain"}, at={@At(value="INVOKE", target="net.minecraft.world.level.material.FluidState.is(Lnet/minecraft/tags/TagKey;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onGetParticleOptions(Camera pCamera, CallbackInfo ci, float f, RandomSource randomsource, LevelReader levelreader, BlockPos blockpos, BlockPos blockpos1, int i, int j, int k, int l, BlockPos blockpos2, Biome biome, double d0, double d1, BlockState blockstate, FluidState fluidstate, VoxelShape voxelshape, double d2, double d3, double d4) {
        this.stormward$isRainInRosharanBiome = StormwardBiomes.isRosharanBiome((Holder<Biome>)levelreader.m_204166_(blockpos2));
    }

    @ModifyVariable(method={"tickRain"}, at=@At(value="STORE"))
    private ParticleOptions injected(ParticleOptions value) {
        if (this.stormward$isRainInRosharanBiome && value == ParticleTypes.f_123761_) {
            return (ParticleOptions)StormwardParticles.HIGHSTORM.get();
        }
        return value;
    }

    @Redirect(method={"tickRain"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;playLocalSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V"))
    private void onPlayLocalSound(ClientLevel instance, BlockPos blockPos, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, boolean distanceDelay) {
        if (this.stormward$isRainInRosharanBiome) {
            this.f_109461_.f_91073_.m_245747_(blockPos, soundEvent, soundSource, volume + 0.1f, pitch - 0.2f, distanceDelay);
            this.f_109461_.f_91073_.m_245747_(blockPos, (SoundEvent)StormwardSoundEvents.HIGHSTORM.get(), soundSource, 0.5f, pitch, distanceDelay);
        } else {
            this.f_109461_.f_91073_.m_245747_(blockPos, soundEvent, soundSource, volume, pitch, distanceDelay);
        }
    }
}

