/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.mixin.villager;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.shardbearer.AlethiSoldier;
import us.amon.stormward.entity.villager.SphereMerchantOffer;
import us.amon.stormward.entity.villager.StormwardVillagerTrades;
import us.amon.stormward.entity.villager.StormwardVillagerTypes;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.menu.SphereMerchantMenu;
import us.amon.stormward.weather.Highstorm;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    @Final
    public static Map<Item, Integer> f_35369_ = new ImmutableMap.Builder().putAll(Villager.f_35369_).put((Object)((Item)StormwardItems.LAVIS_FLATBREAD.get()), (Object)4).build();

    public VillagerMixin(EntityType<? extends AbstractVillager> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"wantsToPickUp"}, at={@At(value="RETURN")}, cancellable=true)
    private void onWantsToPickUp(ItemStack pStack, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && pStack.m_150930_((Item)StormwardItems.LAVIS_FLATBREAD.get())) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Shadow
    public abstract Brain<Villager> m_6274_();

    @Inject(method={"customServerAiStep"}, at={@At(value="RETURN")})
    private void onCustomServerAiStep(CallbackInfo ci) {
        if (this.f_19797_ % 10 == 0 && Highstorm.isEntityExposedToHighstorm((Entity)this)) {
            this.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)this.m_9236_().m_46467_());
        }
    }

    @Shadow
    public abstract VillagerData m_7141_();

    protected void m_35277_(@NotNull MerchantOffers pGivenMerchantOffers, // Could not load outer class - annotation placement on inner may be incorrect
    VillagerTrades.ItemListing @NotNull [] pNewTrades, int pMaxNumbers) {
        super.m_35277_(pGivenMerchantOffers, pNewTrades, pMaxNumbers);
        if (this.m_7141_().m_35560_() == StormwardVillagerTypes.ALETHI.get() && this.f_35261_ != null) {
            this.f_35261_.replaceAll(pOffer -> pOffer instanceof SphereMerchantOffer ? pOffer : StormwardVillagerTrades.convertVanillaOffer((Villager)this, pOffer));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void onReadAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        Villager villager = (Villager)this;
        if (villager.m_7141_().m_35560_() == StormwardVillagerTypes.ALETHI.get() && pCompound.m_128425_("Offers", 10)) {
            ListTag recipes = pCompound.m_128469_("Offers").m_128437_("Recipes", 10);
            for (int i = 0; i < recipes.size(); ++i) {
                CompoundTag recipe = recipes.m_128728_(i);
                this.f_35261_.set(i, (Object)new SphereMerchantOffer(recipe));
            }
        }
    }

    @Redirect(method={"startTrading"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;openTradingScreen(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/network/chat/Component;I)V"))
    private void injected(Villager pInstance, Player pPlayer, Component pDisplayName, int pLevel) {
        if (pInstance.m_7141_().m_35560_() == StormwardVillagerTypes.ALETHI.get()) {
            MerchantOffers merchantoffers;
            OptionalInt optionalint = pPlayer.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, player) -> new SphereMerchantMenu(id, inventory, (Merchant)this), pDisplayName));
            if (optionalint.isPresent() && !(merchantoffers = this.m_6616_()).isEmpty()) {
                pPlayer.m_7662_(optionalint.getAsInt(), merchantoffers, pLevel, this.m_7809_(), this.m_7826_(), this.m_7862_());
            }
        } else {
            pInstance.m_45301_(pPlayer, pDisplayName, pLevel);
        }
    }

    @Inject(method={"spawnGolemIfNeeded"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/SpawnUtil;trySpawnMob(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;IIILnet/minecraft/util/SpawnUtil$Strategy;)Ljava/util/Optional;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void onSpawnGolemIfNeeded(ServerLevel pServerLevel, long pGameTime, int pMinVillagerAmount, CallbackInfo ci, AABB aabb, List<Villager> list, List<Villager> list1) {
        if (((Villager)this).m_7141_().m_35560_().equals(StormwardVillagerTypes.ALETHI.get())) {
            Optional leader = SpawnUtil.m_216403_((EntityType)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (ServerLevel)pServerLevel, (BlockPos)this.m_20183_(), (int)10, (int)8, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216412_);
            if (leader.isPresent()) {
                ((AlethiSoldier)leader.get()).setLighteyes(true);
                for (int i = 0; i < 2; ++i) {
                    SpawnUtil.m_216403_((EntityType)((EntityType)StormwardEntities.ALETHI_SOLDIER.get()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (ServerLevel)pServerLevel, (BlockPos)this.m_20183_(), (int)10, (int)8, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216412_);
                }
                list.forEach(GolemSensor::m_26649_);
            }
            ci.cancel();
        }
    }
}

