/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.network;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import us.amon.stormward.network.ClientboundBookScreenOpenPacket;
import us.amon.stormward.network.ClientboundChullScreenOpenPacket;
import us.amon.stormward.network.ClientboundNextRainTickPacket;
import us.amon.stormward.network.ClientboundRotatePlayerPacket;
import us.amon.stormward.network.ClientboundStormlightTraderScreenOpenPacket;
import us.amon.stormward.network.ClientboundTuskPacket;
import us.amon.stormward.network.ServerboundSetAscenderAnglePacket;
import us.amon.stormward.network.ServerboundSetDetectedEssencePacket;

public class PacketHandler {
    private static final SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)new ResourceLocation("stormward", "main")).serverAcceptedVersions((status, version) -> true).clientAcceptedVersions((status, version) -> true).networkProtocolVersion(1).simpleChannel();

    public static void register() {
        INSTANCE.messageBuilder(ClientboundRotatePlayerPacket.class, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientboundRotatePlayerPacket::write).decoder(ClientboundRotatePlayerPacket::new).consumerMainThread(ClientboundRotatePlayerPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundChullScreenOpenPacket.class, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientboundChullScreenOpenPacket::write).decoder(ClientboundChullScreenOpenPacket::new).consumerMainThread(ClientboundChullScreenOpenPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundNextRainTickPacket.class, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientboundNextRainTickPacket::write).decoder(ClientboundNextRainTickPacket::new).consumerMainThread(ClientboundNextRainTickPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundBookScreenOpenPacket.class, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientboundBookScreenOpenPacket::write).decoder(ClientboundBookScreenOpenPacket::new).consumerMainThread(ClientboundBookScreenOpenPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundTuskPacket.class, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientboundTuskPacket::write).decoder(ClientboundTuskPacket::new).consumerMainThread(ClientboundTuskPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundStormlightTraderScreenOpenPacket.class, NetworkDirection.PLAY_TO_CLIENT).encoder(ClientboundStormlightTraderScreenOpenPacket::write).decoder(ClientboundStormlightTraderScreenOpenPacket::new).consumerMainThread(ClientboundStormlightTraderScreenOpenPacket::handle).add();
        INSTANCE.messageBuilder(ServerboundSetAscenderAnglePacket.class, NetworkDirection.PLAY_TO_SERVER).encoder(ServerboundSetAscenderAnglePacket::write).decoder(ServerboundSetAscenderAnglePacket::new).consumerMainThread(ServerboundSetAscenderAnglePacket::handle).add();
        INSTANCE.messageBuilder(ServerboundSetDetectedEssencePacket.class, NetworkDirection.PLAY_TO_SERVER).encoder(ServerboundSetDetectedEssencePacket::write).decoder(ServerboundSetDetectedEssencePacket::new).consumerMainThread(ServerboundSetDetectedEssencePacket::handle).add();
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        INSTANCE.send(msg, PacketDistributor.PLAYER.with((Object)player));
    }

    public static void sendToTrackingEntity(Object msg, Entity entity) {
        INSTANCE.send(msg, PacketDistributor.TRACKING_ENTITY.with((Object)entity));
    }

    public static void sendToTrackingBlock(Object msg, Level pLevel, BlockPos pPos) {
        INSTANCE.send(msg, PacketDistributor.TRACKING_CHUNK.with((Object)pLevel.m_46745_(pPos)));
    }

    public static void sendToDimension(Object msg, ResourceKey<Level> dimension) {
        INSTANCE.send(msg, PacketDistributor.DIMENSION.with(dimension));
    }

    public static void sendToServer(Object msg) {
        INSTANCE.send(msg, PacketDistributor.SERVER.noArg());
    }

    public static void sendToAll(Object msg) {
        INSTANCE.send(msg, PacketDistributor.ALL.noArg());
    }
}

