/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.stormlightstorage.StormlightStorageBlock;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.screen.book.BookScreen;
import us.amon.stormward.screen.book.BookmarkButton;
import us.amon.stormward.screen.book.EllipsesButton;
import us.amon.stormward.screen.book.IFlippable;
import us.amon.stormward.screen.book.chapter.Chapter;
import us.amon.stormward.screen.book.chapter.ElementChapter;
import us.amon.stormward.screen.book.part.IndexedPart;
import us.amon.stormward.screen.book.part.Part;
import us.amon.stormward.screen.book.part.SingleChapterPart;

public class Book
implements IFlippable {
    public static final String BOOK_PATH = "book";
    public static final String PART_PREFIX = "parts/";
    public static final String CHAPTER_PREFIX = "chapters/";
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("stormward", "textures/gui/book/book.png");
    public static final Style STYLE = Style.f_131099_.m_131150_(new ResourceLocation("stormward", "book"));
    public static final TextColor TITLE_COLOR = TextColor.m_131266_((int)3290449);
    private static final int BOOKMARK_Y = 173;
    private static final int BOOKMARK_MARGIN = 5;
    public static final int MAX_BOOKMARKS_ON_SIDE = 5;
    public static final int BOOKMARK_HEIGHT = 200;
    private final Gson gson = new Gson();
    public final Font font;
    public final BookScreen screen;
    private final String key;
    private final String namespace;
    private final String prefix;
    private final boolean preface;
    private final List<BookmarkButton> bookmarks;
    private EllipsesButton leftEllipses;
    private EllipsesButton rightEllipses;
    private final List<Part> parts;
    private Part part;
    private int partNum;
    private final Map<ResourceLocation, ResourceLocation> resourceChapters;
    private final Map<ResourceLocation, Chapter> chapterCache;

    public Book(BookScreen pScreen, ResourceLocation pBookId) {
        this.screen = pScreen;
        this.font = Minecraft.m_91087_().f_91062_;
        this.chapterCache = new HashMap<ResourceLocation, Chapter>();
        this.key = pBookId.m_135827_() + ".book." + pBookId.m_135815_();
        this.namespace = pBookId.m_135827_();
        this.prefix = "books/" + pBookId.m_135815_() + "/";
        JsonObject bookJson = this.getJsonFromId(new ResourceLocation(this.getNamespace(), BOOK_PATH));
        this.parts = new ArrayList<Part>();
        this.bookmarks = new ArrayList<BookmarkButton>();
        this.preface = bookJson.has("preface");
        if (this.preface) {
            this.parts.add(new SingleChapterPart(this, new ResourceLocation(this.getNamespace(), bookJson.get("preface").getAsString())));
        }
        bookJson.getAsJsonArray("parts").forEach(element -> this.parts.add(this.getPartFromId(new ResourceLocation(this.getNamespace(), element.getAsString()))));
        this.resourceChapters = new HashMap<ResourceLocation, ResourceLocation>();
        if (bookJson.has("resource_chapters")) {
            for (Map.Entry entry : bookJson.getAsJsonObject("resource_chapters").entrySet()) {
                this.resourceChapters.put(new ResourceLocation((String)entry.getKey()), new ResourceLocation(this.namespace, ((JsonElement)entry.getValue()).getAsString()));
            }
        }
        this.flipToFront();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPart(int pIndex, boolean pFlipToFront) {
        if (this.part != null) {
            this.part.flipAway();
        }
        this.partNum = pIndex;
        this.part = this.parts.get(this.partNum);
        if (pFlipToFront) {
            this.part.flipToFront();
        } else {
            this.part.flipToBack();
        }
        this.updateBookmarkPositions();
        this.screen.updateButtonVisibility();
    }

    public boolean hasChapter(ResourceLocation pChapterId) {
        for (int i = 0; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).hasChapter(pChapterId)) continue;
            return true;
        }
        return false;
    }

    public boolean setChapter(ResourceLocation pChapterId) {
        for (int i = 0; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).hasChapter(pChapterId)) continue;
            this.setPart(i, true);
            this.parts.get(i).setChapter(pChapterId);
            return true;
        }
        return false;
    }

    public ResourceLocation getCurrentChapter() {
        return this.part.getCurrentChapter();
    }

    public ResourceLocation getChapterForResource(ResourceLocation pResourceId) {
        if (pResourceId == null) {
            return null;
        }
        ResourceLocation id = this.resourceChapters.get(pResourceId);
        if (id != null) {
            return id;
        }
        if (this.hasChapter(pResourceId)) {
            return pResourceId;
        }
        if (pResourceId.m_135827_().equals(this.namespace)) {
            for (Part part : this.parts) {
                for (ResourceLocation chapterId : part.getChapters()) {
                    String path = chapterId.m_135815_().substring(chapterId.m_135815_().lastIndexOf(47) + 1);
                    if (!path.equals(pResourceId.m_135815_())) continue;
                    return chapterId;
                }
            }
        }
        return null;
    }

    public Part getPart(int pIndex) {
        return this.parts.get(pIndex);
    }

    @Override
    public void flipToFront() {
        this.setPart(0, true);
    }

    @Override
    public void flipToBack() {
        this.setPart(this.parts.size() - 1, false);
    }

    @Override
    public boolean hasNext() {
        return this.part.hasNext() || this.partNum < this.parts.size() - 1;
    }

    @Override
    public void next() {
        if (this.part.hasNext()) {
            this.part.next();
        } else if (this.hasNext()) {
            this.setPart(this.partNum + 1, true);
        }
        this.updateBookmarkPositions();
    }

    @Override
    public boolean hasPrevious() {
        return this.part.hasPrevious() || this.partNum > 0;
    }

    @Override
    public void previous() {
        if (this.part.hasPrevious()) {
            this.part.previous();
        } else if (this.hasPrevious()) {
            this.setPart(this.partNum - 1, false);
        }
        this.updateBookmarkPositions();
    }

    public void refresh() {
        int i;
        this.part.refresh();
        this.bookmarks.clear();
        int n = i = this.preface ? 1 : 0;
        while (i < this.parts.size()) {
            this.bookmarks.add(this.addWidget(new BookmarkButton(this, i, 0, 173)));
            ++i;
        }
        this.leftEllipses = this.addWidget(new EllipsesButton(this, 37, 173));
        this.rightEllipses = this.addWidget(new EllipsesButton(this, 216, 173));
        this.updateBookmarkPositions();
        for (BookmarkButton bookmark : this.bookmarks) {
            bookmark.endMove();
        }
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.part.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderBackground(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280163_(BACKGROUND_LOCATION, 0, 0, 0.0f, 0.0f, 512, 256, 512, 256);
    }

    public void tick() {
        this.part.tick();
        for (BookmarkButton bookmark : this.bookmarks) {
            bookmark.tick();
        }
    }

    public void updateBookmarkPositions() {
        if (this.bookmarks.isEmpty()) {
            return;
        }
        int firstBookmarkOnRight = this.partNum;
        boolean firstBookmarkIsFront = true;
        if (this.preface) {
            if (firstBookmarkOnRight > 0) {
                --firstBookmarkOnRight;
            } else {
                firstBookmarkIsFront = false;
            }
        }
        if (this.part.hasPrevious()) {
            ++firstBookmarkOnRight;
            firstBookmarkIsFront = false;
        }
        int bookmarksOnRight = this.bookmarks.size() - firstBookmarkOnRight;
        int bookmarksOnLeft = this.bookmarks.size() - bookmarksOnRight;
        boolean bl = this.leftEllipses.f_93624_ = bookmarksOnLeft > 5;
        if (this.leftEllipses.f_93624_) {
            this.leftEllipses.setRange(firstBookmarkOnRight - 5 + 1, 1);
        }
        boolean bl2 = this.rightEllipses.f_93624_ = bookmarksOnRight > 5;
        if (this.rightEllipses.f_93624_) {
            this.rightEllipses.setRange(firstBookmarkOnRight + 5 - 2, this.bookmarks.size() - 2);
        }
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            BookmarkButton bookmark = this.bookmarks.get(i);
            int position = i - firstBookmarkOnRight;
            bookmark.setFront(position == 0 && firstBookmarkIsFront);
            bookmark.setZ(Math.min(Math.abs(position), 5) * 200);
            if (i == 0 && this.leftEllipses.f_93624_ || i == this.bookmarks.size() - 1 && this.rightEllipses.f_93624_) {
                bookmark.setZ(1200);
            }
            bookmark.f_93623_ = true;
            if (position >= 0) {
                if (this.rightEllipses.f_93624_ && position >= 3 && position < bookmarksOnRight - 1) {
                    bookmark.f_93623_ = false;
                    position = 5;
                }
                bookmark.moveTo(this.screen.getCornerX() + 141 + Math.min(position, 4) * 25);
                continue;
            }
            if (this.leftEllipses.f_93624_ && position < -3 && position > -bookmarksOnLeft) {
                bookmark.f_93623_ = false;
                position = -5;
            }
            bookmark.moveTo(this.screen.getCornerX() + 17 + 115 - 20 + Math.max(position + 1, -4) * 25);
        }
    }

    public JsonObject getJsonFromId(ResourceLocation pId) {
        ResourceLocation path = pId.m_246208_(this.prefix).m_266382_(".json");
        return Minecraft.m_91087_().m_91098_().m_213713_(path).map(this::getJsonFromResource).orElse(null);
    }

    public JsonObject getJsonFromResource(Resource pResource) {
        try {
            InputStream input = pResource.m_215507_();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            JsonElement element = (JsonElement)this.gson.fromJson((Reader)reader, JsonElement.class);
            return element.getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<ResourceLocation, Resource> getResourcesFromFolder(String pFolder) {
        return Minecraft.m_91087_().m_91098_().m_214159_(this.prefix + pFolder, id -> id.m_135827_().equals(this.namespace) && id.m_135815_().endsWith(".json"));
    }

    public Part getPartFromId(ResourceLocation pPartId) {
        return new IndexedPart(this, this.getPartTitle(pPartId), this.getJsonFromId(pPartId.m_246208_(PART_PREFIX)));
    }

    public Component getPartTitle(ResourceLocation pPartId) {
        return Component.m_237115_((String)(this.key + ".part." + pPartId.m_135815_().replace("/", ".") + ".title")).m_130948_(STYLE);
    }

    public Chapter getChapterFromId(ResourceLocation pChapterId) {
        Chapter cachedChapter = this.chapterCache.get(pChapterId);
        if (cachedChapter != null) {
            return cachedChapter;
        }
        JsonObject chapterJson = this.getJsonFromId(pChapterId.m_246208_(CHAPTER_PREFIX));
        if (chapterJson != null) {
            ElementChapter chapter = new ElementChapter(this, this.getChapterTitle(pChapterId), chapterJson);
            this.chapterCache.put(pChapterId, chapter);
            return chapter;
        }
        return null;
    }

    public Component getChapterTitle(ResourceLocation pChapterId) {
        return Component.m_237115_((String)(this.key + ".chapter." + pChapterId.m_135815_().replace("/", ".") + ".title")).m_130948_(STYLE);
    }

    public ItemStack getItemStackFromString(String pString) {
        if (pString.charAt(0) == '{') {
            return this.getItemStackFromNbt(pString);
        }
        if (Minecraft.m_91087_().f_91073_ != null) {
            HolderLookup itemLookup = Minecraft.m_91087_().f_91073_.m_246945_(Registries.f_256913_);
            try {
                ItemParser.ItemResult result = ItemParser.m_235305_((HolderLookup)itemLookup, (StringReader)new StringReader(pString));
                ItemStack stack = new ItemStack(result.f_235328_());
                StormlightStorageHelper.setFull((ICapabilityProvider)stack);
                if (result.f_235329_() != null) {
                    stack.m_41751_(result.f_235329_());
                }
                return stack;
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getItemStackFromNbt(String pNbt) {
        try {
            return ItemStack.m_41712_((CompoundTag)new TagParser(new StringReader(pNbt)).m_129373_());
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public BlockState getStateFromString(String pString) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            HolderLookup blockLookup = Minecraft.m_91087_().f_91073_.m_246945_(Registries.f_256747_);
            try {
                BlockState state = BlockStateParser.m_245437_((HolderLookup)blockLookup, (String)pString, (boolean)true).f_234748_();
                if (state.m_61138_((Property)StormlightStorageBlock.DUN)) {
                    state = (BlockState)state.m_61124_((Property)StormlightStorageBlock.DUN, (Comparable)Boolean.valueOf(false));
                }
                return state;
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return Blocks.f_50016_.m_49966_();
    }

    public Item getItemFromId(ResourceLocation pId) {
        return (Item)ForgeRegistries.ITEMS.getValue(pId);
    }

    public ResourceLocation getIdFromItem(Item pItem) {
        return ForgeRegistries.ITEMS.getKey((Object)pItem);
    }

    public Block getBlockFromId(ResourceLocation pId) {
        return (Block)ForgeRegistries.BLOCKS.getValue(pId);
    }

    public ResourceLocation getIdFromBlock(Block pBlock) {
        return ForgeRegistries.BLOCKS.getKey((Object)pBlock);
    }

    public Entity getEntityFromJson(JsonObject pEntityJson) {
        Entity entity = this.getEntityFromId(new ResourceLocation(pEntityJson.get("entity").getAsString()));
        if (entity != null) {
            if (pEntityJson.has("nbt")) {
                try {
                    CompoundTag nbt = TagParser.m_129359_((String)pEntityJson.get("nbt").getAsString());
                    entity.m_20258_(nbt);
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (pEntityJson.has("data")) {
                for (JsonElement dataJson : pEntityJson.getAsJsonArray("data")) {
                    JsonObject dataObject = dataJson.getAsJsonObject();
                    int id = dataObject.get("id").getAsInt();
                    JsonElement value = dataObject.get("value");
                    SynchedEntityData entityData = entity.m_20088_();
                    switch (dataObject.get("serializer").getAsString()) {
                        case "byte": {
                            entityData.m_135381_(EntityDataSerializers.f_135027_.m_135021_(id), (Object)value.getAsByte());
                            break;
                        }
                        case "int": {
                            entityData.m_135381_(EntityDataSerializers.f_135028_.m_135021_(id), (Object)value.getAsInt());
                            break;
                        }
                        case "long": {
                            entityData.m_135381_(EntityDataSerializers.f_244073_.m_135021_(id), (Object)value.getAsLong());
                            break;
                        }
                        case "float": {
                            entityData.m_135381_(EntityDataSerializers.f_135029_.m_135021_(id), (Object)Float.valueOf(value.getAsFloat()));
                            break;
                        }
                        case "string": {
                            entityData.m_135381_(EntityDataSerializers.f_135030_.m_135021_(id), (Object)value.getAsString());
                            break;
                        }
                        case "boolean": {
                            entityData.m_135381_(EntityDataSerializers.f_135035_.m_135021_(id), (Object)value.getAsBoolean());
                        }
                    }
                }
            }
        }
        return entity;
    }

    public Entity getEntityFromId(ResourceLocation pEntityId) {
        EntityType entityType;
        if (Minecraft.m_91087_().f_91073_ != null && (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(pEntityId)) != null) {
            return entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        }
        return null;
    }

    public Recipe<?> getRecipeFromId(ResourceLocation pRecipeId) {
        return ((RecipeHolder)Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(pRecipeId).orElseThrow()).f_291008_();
    }

    public <T extends AbstractWidget> T addWidget(T pWidget) {
        return this.screen.addWidgetToBookScreen(pWidget);
    }

    public void removeWidget(GuiEventListener pWidget) {
        this.screen.removeWidgetFromBookScreen(pWidget);
    }

    public Font getFont() {
        return this.font;
    }

    public boolean mouseClicked(double pX, double pY, int pButton) {
        return this.part.mouseClicked(pX, pY, pButton);
    }
}

