/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book;

import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.item.book.BookItem;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.ExitButton;

public class BookScreen
extends Screen {
    public static final int BOOK_WIDTH = 274;
    public static final int BOOK_HEIGHT = 192;
    private final Book book;
    private int cornerX;
    private int cornerY;
    private PageButton forwardButton;
    private PageButton backButton;

    public BookScreen(Player pOwner, ItemStack pBook, InteractionHand pHand) {
        super(GameNarrator.f_93310_);
        this.book = new Book(this, ((BookItem)pBook.m_41720_()).getBookId());
    }

    protected void m_7856_() {
        this.cornerX = (this.f_96543_ - 274) / 2;
        this.cornerY = (this.f_96544_ - 192) / 2;
        this.book.refresh();
        this.createMenuControls();
        this.createPageControlButtons();
    }

    public int getCornerX() {
        return this.cornerX;
    }

    public int getCornerY() {
        return this.cornerY;
    }

    public void m_86600_() {
        this.book.tick();
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)this.cornerX, (float)this.cornerY, 0.0f);
        this.book.render(pGuiGraphics, pMouseX - this.cornerX, pMouseY - this.cornerY, pPartialTick);
        pGuiGraphics.m_280168_().m_85849_();
    }

    public void m_280273_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_280273_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_((float)this.cornerX, (float)this.cornerY, 0.0f);
        this.book.renderBackground(pGuiGraphics, pMouseX - this.cornerX, pMouseY - this.cornerY, pPartialTick);
        pGuiGraphics.m_280168_().m_85849_();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (super.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return switch (pKeyCode) {
            case 266 -> {
                this.backButton.m_5691_();
                yield true;
            }
            case 267 -> {
                this.forwardButton.m_5691_();
                yield true;
            }
            default -> false;
        };
    }

    protected void createPageControlButtons() {
        this.forwardButton = this.addWidgetToBookScreen(new PageButton(225, 155, true, button -> this.pageForward(), true));
        this.backButton = this.addWidgetToBookScreen(new PageButton(24, 155, false, button -> this.pageBack(), true));
        this.updateButtonVisibility();
    }

    private void pageForward() {
        this.book.next();
        this.updateButtonVisibility();
    }

    private void pageBack() {
        this.book.previous();
        this.updateButtonVisibility();
    }

    public void updateButtonVisibility() {
        if (this.book != null) {
            this.forwardButton.f_93624_ = this.book.hasNext();
            this.backButton.f_93624_ = this.book.hasPrevious();
        }
    }

    protected void createMenuControls() {
        this.addWidgetToBookScreen(new ExitButton(243, 11, button -> this.m_7379_()));
    }

    public <T extends AbstractWidget> T addWidgetToBookScreen(T pWidget) {
        pWidget.m_252865_(this.cornerX + pWidget.m_252754_());
        pWidget.m_253211_(this.cornerY + pWidget.m_252907_());
        return (T)((AbstractWidget)this.m_142416_((GuiEventListener)pWidget));
    }

    public void removeWidgetFromBookScreen(GuiEventListener pWidget) {
        this.m_169411_(pWidget);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.book.mouseClicked(pMouseX - (double)this.cornerX, pMouseY - (double)this.cornerY, pButton)) {
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }
}

