/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.chapter;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.IFlippable;

public abstract class Chapter
implements IFlippable {
    public static final int LEFT_PAGE_X = 17;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TITLE_Y = 14;
    public static final int BODY_Y = 28;
    public static final int WIDTH = 115;
    public static final int HEIGHT = 154;
    private static final Component ELLIPSES = Component.m_237113_((String)"...").m_130948_(Book.STYLE);
    protected final Book book;
    private final Component title;
    private final Component shortenedTitle;
    protected int spread;

    public Chapter(Book pBook, Component pTitle) {
        this.book = pBook;
        this.title = pTitle;
        if (this.book.getFont().m_92852_((FormattedText)this.title) <= 115) {
            this.shortenedTitle = null;
        } else {
            String text = this.book.getFont().m_92854_((FormattedText)pTitle, 115 - this.book.getFont().m_92852_((FormattedText)ELLIPSES)).getString() + ELLIPSES.getString();
            this.shortenedTitle = Component.m_237113_((String)text).m_130948_(pTitle.m_7383_());
        }
    }

    public int getNumSpreads() {
        return 1;
    }

    public void setSpread(int pIndex) {
        this.removeWidgets();
        this.spread = pIndex;
        this.updateSpread();
        this.addWidgets();
    }

    protected void updateSpread() {
    }

    public abstract void tick();

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderTitle(pGuiGraphics, pMouseX, pMouseY);
    }

    public boolean mouseClicked(double pX, double pY, int pButton) {
        return false;
    }

    @Override
    public void flipToFront() {
        this.setSpread(0);
    }

    @Override
    public void flipToBack() {
        this.setSpread(this.getNumSpreads() - 1);
    }

    @Override
    public void flipAway() {
        this.removeWidgets();
    }

    public void refresh() {
        this.setSpread(this.spread);
    }

    protected void addWidgets() {
    }

    protected void removeWidgets() {
    }

    @Override
    public boolean hasNext() {
        return this.spread < this.getNumSpreads() - 1;
    }

    @Override
    public void next() {
        if (this.hasNext()) {
            this.setSpread(this.spread + 1);
        }
    }

    @Override
    public boolean hasPrevious() {
        return this.spread > 0;
    }

    @Override
    public void previous() {
        if (this.hasPrevious()) {
            this.setSpread(this.spread - 1);
        }
    }

    protected void renderTitle(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (this.shortenedTitle == null) {
            pGuiGraphics.m_280614_(this.book.getFont(), this.title, 17 + (115 - this.book.getFont().m_92852_((FormattedText)this.title)) / 2, 14, Book.TITLE_COLOR.m_131265_(), false);
        } else {
            pGuiGraphics.m_280614_(this.book.getFont(), this.shortenedTitle, 17, 14, Book.TITLE_COLOR.m_131265_(), false);
            if (pMouseX >= 17 && pMouseX < 132 && pMouseY >= 14) {
                Objects.requireNonNull(this.book.getFont());
                if (pMouseY < 14 + 9) {
                    pGuiGraphics.m_280557_(this.book.getFont(), this.title, pMouseX, pMouseY);
                }
            }
        }
    }
}

