/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.Element;

public class PageElement
extends Element {
    private final Size size;
    private final int margin;

    public PageElement(Book pBook, JsonObject pElementJson) {
        super(pBook);
        this.size = Size.fromJson(pElementJson, this.getDefaultSize(pElementJson));
        this.margin = pElementJson.has("margin") ? pElementJson.get("margin").getAsInt() : super.getMargin();
    }

    protected Size getDefaultSize(JsonObject pElementJson) {
        return Size.MEDIUM;
    }

    @Override
    public int getMargin() {
        return this.margin;
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_292816_(this.size.getBackgroundLocation(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Size getSize() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return this.size.getHeight();
    }

    public static enum Size {
        SMALL(42, new ResourceLocation("stormward", "book/small_background")),
        MEDIUM(63, new ResourceLocation("stormward", "book/medium_background")),
        LARGE(84, new ResourceLocation("stormward", "book/large_background"));

        private final int height;
        private final ResourceLocation backgroundLocation;

        private Size(int pHeight, ResourceLocation pBackgroundLocation) {
            this.height = pHeight;
            this.backgroundLocation = pBackgroundLocation;
        }

        public int getHeight() {
            return this.height;
        }

        public ResourceLocation getBackgroundLocation() {
            return this.backgroundLocation;
        }

        public static Size fromJson(JsonObject pJson, Size pFallback) {
            if (!pJson.has("size")) {
                return pFallback;
            }
            return switch (pJson.get("size").getAsString()) {
                case "small" -> SMALL;
                case "large" -> LARGE;
                default -> MEDIUM;
            };
        }
    }
}

