/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.PageElement;

public class SpritePageElement
extends PageElement {
    private final ResourceLocation sprite;
    private final int width;
    private final int height;

    public SpritePageElement(Book pBook, JsonObject pElementJson) {
        super(pBook, pElementJson);
        this.sprite = new ResourceLocation(pElementJson.get("sprite").getAsString());
        this.width = pElementJson.has("width") ? pElementJson.get("width").getAsInt() : this.getWidth();
        this.height = pElementJson.has("height") ? pElementJson.get("height").getAsInt() : this.getHeight();
    }

    @Override
    protected PageElement.Size getDefaultSize(JsonObject pElementJson) {
        if (pElementJson.has("height")) {
            int height = pElementJson.get("height").getAsInt();
            if (height <= PageElement.Size.SMALL.getHeight()) {
                return PageElement.Size.SMALL;
            }
            if (height <= PageElement.Size.MEDIUM.getHeight()) {
                return PageElement.Size.MEDIUM;
            }
            return PageElement.Size.LARGE;
        }
        return super.getDefaultSize(pElementJson);
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_292816_(this.sprite, this.getX() + (this.getWidth() - this.width) / 2, this.getY() + (this.getHeight() - this.height) / 2, this.width, this.height);
    }
}

