/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.Element;

public class TextElement
extends Element {
    private static final int DEFAULT_MARGIN = 1;
    private static final Style STYLE = Book.STYLE.m_178520_(5330541);
    private static final FormattedCharSequence LIST_ITEM_PREFIX = FormattedCharSequence.m_13714_((String)" - ", (Style)STYLE);
    private final FormattedCharSequence text;
    private final int indent;
    private final int margin;
    private final boolean empty;
    private final boolean linked;

    private TextElement(Book pBook, FormattedCharSequence pText) {
        this(pBook, pText, 0, 1, false);
    }

    private TextElement(Book pBook, FormattedCharSequence pText, int pIndent, int pMargin, boolean pLinked) {
        super(pBook);
        this.text = pText;
        this.indent = pIndent;
        this.empty = this.book.getFont().m_92724_(this.text) <= 0;
        this.margin = this.empty ? 0 : pMargin;
        this.linked = pLinked;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean isLinked() {
        return this.linked;
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280649_(this.book.getFont(), this.text, this.getX() + this.indent, this.getY(), 0, false);
        ResourceLocation chapterId = this.getChapterIdAtMouse(pMouseX, pMouseY);
        if (chapterId != null && !chapterId.equals((Object)this.book.getCurrentChapter())) {
            pGuiGraphics.m_280557_(this.book.getFont(), this.book.getChapterTitle(chapterId), pMouseX, pMouseY);
        }
    }

    private ResourceLocation getChapterIdAtMouse(double pMouseX, double pMouseY) {
        ClickEvent clickEvent;
        Style style;
        if (pMouseX >= (double)this.getX() && pMouseX < (double)(this.getX() + this.getWidth()) && pMouseY >= (double)this.getY() && pMouseY < (double)(this.getY() + this.getHeight()) && (style = this.book.getFont().m_92865_().m_92338_(this.text, Mth.m_14107_((double)(pMouseX - (double)this.getX() - (double)this.indent)))) != null && (clickEvent = style.m_131182_()) != null && clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            return new ResourceLocation(this.book.getNamespace(), clickEvent.m_130623_());
        }
        return null;
    }

    @Override
    public int getHeight() {
        int n;
        if (this.empty) {
            n = 6;
        } else {
            Objects.requireNonNull(this.book.getFont());
            n = 9;
        }
        return n;
    }

    @Override
    public int getMargin() {
        return this.margin;
    }

    @Override
    public boolean mouseClicked(double pX, double pY, int pButton) {
        ResourceLocation chapterId;
        if (pButton == 0 && (chapterId = this.getChapterIdAtMouse(pX, pY)) != null && !chapterId.equals((Object)this.book.getCurrentChapter()) && this.book.setChapter(chapterId)) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            return true;
        }
        return super.mouseClicked(pX, pY, pButton);
    }

    public static List<TextElement> fromString(Book pBook, String pString) {
        return pBook.getFont().m_92923_(FormattedText.m_130762_((String)pString, (Style)STYLE), 115).stream().map(text -> new TextElement(pBook, (FormattedCharSequence)text)).toList();
    }

    public static List<TextElement> fromJsonObject(Book pBook, JsonObject pTextJson) {
        return TextElement.getElements(pBook, (JsonElement)(pTextJson.has("parts") ? pTextJson.get("parts") : pTextJson), 0, false);
    }

    private static List<TextElement> getElements(Book pBook, JsonElement pTextJson, int pOffset, boolean pLinked) {
        ArrayList<TextElement> elements = new ArrayList<TextElement>();
        ArrayList<FormattedText> parts = new ArrayList<FormattedText>();
        if (!pTextJson.isJsonArray()) {
            TextElement.getElement(pBook, pTextJson, pOffset, pLinked, elements, parts);
        } else {
            for (JsonElement partJson : pTextJson.getAsJsonArray()) {
                TextElement.getElement(pBook, partJson, pOffset, pLinked, elements, parts);
            }
        }
        elements.addAll(TextElement.getElementsFromParts(pBook, parts, pOffset, pLinked));
        return elements;
    }

    private static void getElement(Book pBook, JsonElement pTextJson, int pIndent, boolean pLinked, List<TextElement> pElements, List<FormattedText> pParts) {
        Style style = STYLE;
        String text = "";
        if (pTextJson.isJsonObject()) {
            JsonObject textObject = pTextJson.getAsJsonObject();
            if (textObject.has("list_item")) {
                pElements.addAll(TextElement.getElementsFromParts(pBook, pParts, pIndent, pLinked));
                pParts.clear();
                List<TextElement> listItemElements = TextElement.getElements(pBook, textObject.get("list_item"), pIndent + pBook.getFont().m_92724_(LIST_ITEM_PREFIX), true);
                TextElement first = listItemElements.get(0);
                listItemElements.set(0, new TextElement(pBook, FormattedCharSequence.m_13696_((FormattedCharSequence)LIST_ITEM_PREFIX, (FormattedCharSequence)first.text), pIndent, first.margin, first.linked));
                TextElement last = listItemElements.get(listItemElements.size() - 1);
                listItemElements.set(listItemElements.size() - 1, new TextElement(pBook, last.text, last.indent, 5, last.linked));
                pElements.addAll(listItemElements);
                return;
            }
            if (textObject.has("key")) {
                text = Component.m_237115_((String)textObject.get("key").getAsString()).getString();
            } else if (textObject.has("text")) {
                text = textObject.get("text").getAsString();
            }
            if (textObject.has("header") && textObject.get("header").getAsBoolean()) {
                style = style.m_131148_(Book.TITLE_COLOR);
            }
            if (textObject.has("chapter_id")) {
                style = style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, textObject.get("chapter_id").getAsString()));
            }
        } else {
            text = pTextJson.getAsString();
        }
        pParts.add(FormattedText.m_130762_((String)text, (Style)style));
    }

    private static List<TextElement> getElementsFromParts(Book pBook, List<FormattedText> pParts, int pIndent, boolean pLinked) {
        ArrayList<TextElement> elements = new ArrayList<TextElement>();
        List texts = pBook.getFont().m_92923_(FormattedText.m_130768_(pParts), 115 - pIndent);
        for (int i = 0; i < texts.size(); ++i) {
            Style style = pBook.getFont().m_92865_().m_92338_((FormattedCharSequence)texts.get(i), 0);
            boolean header = style != null && style.m_131135_() != null && style.m_131135_().equals((Object)Book.TITLE_COLOR);
            elements.add(new TextElement(pBook, (FormattedCharSequence)texts.get(i), pIndent, header ? 3 : 1, pLinked && i < texts.size() - 1 || header));
        }
        return elements;
    }
}

