/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import us.amon.stormward.screen.book.element.animation.AnimationActor;
import us.amon.stormward.screen.book.element.animation.AnimationStep;
import us.amon.stormward.screen.book.element.animation.EmitAction;
import us.amon.stormward.screen.book.element.animation.InteractAction;
import us.amon.stormward.screen.book.element.animation.MoveAction;
import us.amon.stormward.screen.book.element.animation.SetVisibilityAction;

public abstract class AnimationAction {
    public final String actor;

    public AnimationAction(String pActor) {
        this.actor = pActor;
    }

    public void startAction(AnimationActor pActor, AnimationStep pStep) {
    }

    public void tickAction(AnimationActor pActor, int pStepTime) {
    }

    public void endAction(AnimationActor pActor) {
    }

    public String getActor() {
        return this.actor;
    }

    public static AnimationAction getActionFromJson(String pActor, JsonElement pActionJson) {
        if (pActionJson.isJsonObject()) {
            JsonObject json = pActionJson.getAsJsonObject();
            return switch (json.get("type").getAsString()) {
                case "move" -> new MoveAction(pActor, json);
                case "emit" -> new EmitAction(pActor, json);
                case "interact" -> new InteractAction(pActor);
                default -> new SetVisibilityAction(pActor, json);
            };
        }
        return new SetVisibilityAction(pActor, pActionJson);
    }
}

