/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.amon.stormward.screen.book.element.animation.AnimationAction;

public class AnimationStep {
    private final int duration;
    private final List<AnimationAction> actions;

    public AnimationStep(JsonElement pStepJson) {
        if (pStepJson.isJsonObject()) {
            JsonObject stepObject = pStepJson.getAsJsonObject();
            this.duration = stepObject.has("duration") ? stepObject.get("duration").getAsInt() : 0;
            this.actions = new ArrayList<AnimationAction>();
            for (Map.Entry entry : stepObject.entrySet()) {
                if (((String)entry.getKey()).equals("duration")) continue;
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        this.actions.add(AnimationAction.getActionFromJson((String)entry.getKey(), element));
                    }
                    continue;
                }
                this.actions.add(AnimationAction.getActionFromJson((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
        } else {
            this.duration = pStepJson.getAsInt();
            this.actions = List.of();
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public List<AnimationAction> getActions() {
        return this.actions;
    }
}

