/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.animation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import us.amon.stormward.screen.book.element.animation.AnimationActor;
import us.amon.stormward.screen.book.element.animation.MoveAction;

public class ParticleEmitterActor
extends AnimationActor {
    private final List<ResourceLocation> textures;
    private final Type type;
    private final int lifetime;
    private final int maxLifetime;
    private final MoveAction.MovementType movementType;
    private final double r;
    private final double g;
    private final double b;
    private final double a;
    private final double endR;
    private final double endG;
    private final double endB;
    private final double endA;
    private final double scale;
    private final double endScale;
    protected final RandomSource random = RandomSource.m_216327_();
    private final List<Particle> particles;

    public ParticleEmitterActor(JsonObject pActorJson) {
        super(pActorJson);
        JsonObject color;
        this.textures = new ArrayList<ResourceLocation>();
        for (JsonElement element : pActorJson.getAsJsonArray("textures")) {
            this.textures.add(new ResourceLocation(element.getAsString()).m_246208_("textures/particle/").m_266382_(".png"));
        }
        this.type = Type.fromJson(pActorJson);
        this.lifetime = pActorJson.has("lifetime") ? pActorJson.get("lifetime").getAsInt() : 20;
        this.maxLifetime = pActorJson.has("max_lifetime") ? pActorJson.get("max_lifetime").getAsInt() : this.lifetime;
        this.movementType = MoveAction.MovementType.fromJson(pActorJson);
        if (pActorJson.has("color")) {
            color = pActorJson.getAsJsonObject("color");
            this.r = color.get("r").getAsDouble();
            this.g = color.get("g").getAsDouble();
            this.b = color.get("b").getAsDouble();
            this.a = color.get("a").getAsDouble();
        } else {
            this.a = 1.0;
            this.b = 1.0;
            this.g = 1.0;
            this.r = 1.0;
        }
        if (pActorJson.has("end_color")) {
            color = pActorJson.getAsJsonObject("end_color");
            this.endR = color.get("r").getAsDouble();
            this.endG = color.get("g").getAsDouble();
            this.endB = color.get("b").getAsDouble();
            this.endA = color.get("a").getAsDouble();
        } else {
            this.endR = this.r;
            this.endG = this.g;
            this.endB = this.b;
            this.endA = this.a;
        }
        this.scale = pActorJson.has("scale") ? pActorJson.get("scale").getAsDouble() : 1.0;
        this.endScale = pActorJson.has("end_scale") ? pActorJson.get("end_scale").getAsDouble() : this.scale;
        this.particles = new ArrayList<Particle>();
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return 0;
    }

    public void emit(double pStartX, double pStartY, double pEndX, double pEndY) {
        this.particles.add(new Particle(pStartX, pStartY, pEndX, pEndY));
    }

    @Override
    public void tick() {
        for (int i = this.particles.size() - 1; i >= 0; --i) {
            Particle particle = this.particles.get(i);
            particle.tick();
            if (particle.tickCount <= particle.lifetime) continue;
            this.particles.remove(i);
        }
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        for (Particle particle : this.particles) {
            particle.render(pGuiGraphics, pPartialTick);
        }
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void reset() {
        super.reset();
        this.particles.clear();
    }

    public static enum Type {
        AGE,
        PICK;


        public static Type fromJson(JsonObject pJson) {
            if (pJson.has("type") && pJson.get("type").getAsString().equals("pick")) {
                return PICK;
            }
            return AGE;
        }
    }

    public class Particle {
        protected final double startX;
        protected final double startY;
        protected final double endX;
        protected final double endY;
        protected final int lifetime;
        ResourceLocation texture;
        int tickCount;

        public Particle(double pStartX, double pStartY, double pEndX, double pEndY) {
            this.startX = pStartX;
            this.startY = pStartY;
            this.endX = pEndX;
            this.endY = pEndY;
            this.lifetime = ParticleEmitterActor.this.random.m_216332_(ParticleEmitterActor.this.lifetime, ParticleEmitterActor.this.maxLifetime);
            this.texture = ParticleEmitterActor.this.type == Type.PICK ? ParticleEmitterActor.this.textures.get(ParticleEmitterActor.this.random.m_188503_(ParticleEmitterActor.this.textures.size())) : ParticleEmitterActor.this.textures.get(0);
        }

        public void tick() {
            ++this.tickCount;
            if (ParticleEmitterActor.this.type == Type.AGE) {
                this.texture = ParticleEmitterActor.this.textures.get(Math.min(Mth.m_14143_((float)((float)ParticleEmitterActor.this.textures.size() * ((float)this.tickCount / (float)this.lifetime))), ParticleEmitterActor.this.textures.size() - 1));
            }
        }

        public void render(GuiGraphics pGuiGraphics, float pPartialTick) {
            double pPercent = ((float)this.tickCount + pPartialTick) / (float)this.lifetime;
            double movePercent = ParticleEmitterActor.this.movementType.apply(pPercent);
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_85837_(Mth.m_14139_((double)movePercent, (double)this.startX, (double)this.endX), Mth.m_14139_((double)movePercent, (double)this.startY, (double)this.endY), 200.0);
            float scale = (float)Mth.m_14139_((double)pPercent, (double)ParticleEmitterActor.this.scale, (double)ParticleEmitterActor.this.endScale);
            pGuiGraphics.m_280168_().m_85841_(scale, scale, scale);
            pGuiGraphics.m_280246_((float)Mth.m_14139_((double)pPercent, (double)ParticleEmitterActor.this.r, (double)ParticleEmitterActor.this.endR), (float)Mth.m_14139_((double)pPercent, (double)ParticleEmitterActor.this.g, (double)ParticleEmitterActor.this.endG), (float)Mth.m_14139_((double)pPercent, (double)ParticleEmitterActor.this.b, (double)ParticleEmitterActor.this.endB), (float)Mth.m_14139_((double)pPercent, (double)ParticleEmitterActor.this.a, (double)ParticleEmitterActor.this.endA));
            pGuiGraphics.m_280163_(this.texture, -ParticleEmitterActor.this.width / 2, -ParticleEmitterActor.this.height / 2, 0.0f, 0.0f, ParticleEmitterActor.this.width, ParticleEmitterActor.this.height, ParticleEmitterActor.this.width, ParticleEmitterActor.this.height);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }
}

