/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.obtaining;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.PageElement;
import us.amon.stormward.screen.book.element.obtaining.LootPageElement;
import us.amon.stormward.screen.book.element.resources.BlocksElement;
import us.amon.stormward.screen.book.element.resources.ItemsElement;
import us.amon.stormward.screen.book.element.resources.ItemsOutputElement;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class BlockLootPageElement
extends LootPageElement<BlocksElement, ItemsElement> {
    public BlockLootPageElement(Book pBook, JsonObject pElementJson) {
        super(pBook, pElementJson);
    }

    @Override
    protected String getLeftKey() {
        return "blocks";
    }

    @Override
    protected String getRightKey() {
        return "items";
    }

    @Override
    protected BlocksElement createLeftElement(Book pBook, JsonElement pElementJson) {
        return new BlocksElement(pBook, pElementJson, 16, 16);
    }

    @Override
    protected ItemsElement createRightElement(Book pBook, JsonElement pElementJson) {
        return new ItemsOutputElement(pBook, pElementJson, 16, 16);
    }

    @Override
    protected void initElements() {
        for (ResourcesElement.ResourceData resource : ((BlocksElement)this.leftElement).getResources()) {
            resource.setScale(10.0f);
        }
        for (ResourcesElement.ResourceData resource : ((ItemsElement)this.rightElement).getResources()) {
            resource.setScale(1.0f);
        }
    }

    @Override
    protected void renderToolIcon(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBlockLootToolIcon(pGuiGraphics, pMouseX, pMouseY, pPartialTick, ((BlocksElement.BlockData)((BlocksElement)this.leftElement).getResource()).getState());
    }

    @Override
    protected PageElement.Size getDefaultSize(JsonObject pElementJson) {
        return PageElement.Size.SMALL;
    }
}

