/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.obtaining;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.recipe.FabrialRecipe;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.ChapterButton;
import us.amon.stormward.screen.book.element.obtaining.ObtainingPageElement;
import us.amon.stormward.screen.book.element.resources.CraftingRecipesElement;
import us.amon.stormward.screen.book.element.resources.FabrialOutputsElement;
import us.amon.stormward.screen.book.element.resources.FabrialRecipesElement;

public class FabrialRecipePageElement
extends ObtainingPageElement<FabrialRecipesElement, FabrialOutputsElement> {
    public static final ResourceLocation OBTAINING_ARROW_LOCATION = new ResourceLocation("stormward", "book/fabrial_obtaining_arrow");
    private static final int ARROW_HEIGHT = 22;
    public static final ResourceLocation ARTIFABRIANS_TABLE_ID = new ResourceLocation("stormward", "blocks/artifabrians_table");
    private ChapterButton button;

    public FabrialRecipePageElement(Book pBook, JsonObject pElementJson) {
        super(pBook, pElementJson);
    }

    @Override
    protected String getLeftKey() {
        return "recipes";
    }

    @Override
    protected String getRightKey() {
        return "recipes";
    }

    @Override
    protected FabrialRecipesElement createLeftElement(Book pBook, JsonElement pElementJson) {
        return new FabrialRecipesElement(pBook, pElementJson, 38, 54);
    }

    @Override
    protected FabrialOutputsElement createRightElement(Book pBook, JsonElement pElementJson) {
        return new FabrialOutputsElement(pBook);
    }

    @Override
    protected void initElements() {
        for (CraftingRecipesElement.RecipeData resource : ((FabrialRecipesElement)this.leftElement).getResources()) {
            Recipe<?> recipe = resource.getRecipe();
            if (!(recipe instanceof FabrialRecipe)) continue;
            FabrialRecipe recipe2 = (FabrialRecipe)recipe;
            ItemStack secondaryItem = recipe2.getSecondaryResultItem(null);
            FabrialOutputsElement.FabrialOutputData data = new FabrialOutputsElement.FabrialOutputData(this.book, recipe2.m_8043_(null), secondaryItem);
            ((FabrialOutputsElement)this.rightElement).getResources().add(data);
        }
        ((FabrialOutputsElement)this.rightElement).setInterval(((FabrialRecipesElement)this.leftElement).getInterval());
        ((FabrialOutputsElement)this.rightElement).initResources();
    }

    @Override
    protected int getArrowY() {
        return this.hasSecondaryItem() ? this.getY() + (this.getHeight() - 22) / 2 : super.getArrowY();
    }

    @Override
    protected void renderArrowIcon(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.hasSecondaryItem()) {
            pGuiGraphics.m_292816_(OBTAINING_ARROW_LOCATION, 0, 0, 24, 22);
        } else {
            super.renderArrowIcon(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    @Override
    protected int getToolY() {
        return this.hasSecondaryItem() ? this.getY() + (this.getHeight() - 22) / 2 + 22 : super.getToolY();
    }

    @Override
    protected void renderToolIcon(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280168_().m_85841_(0.75f, 0.75f, 0.75f);
        pGuiGraphics.m_280480_(new ItemStack((ItemLike)StormwardBlocks.ARTIFABRIANS_TABLE.get()), 0, 0);
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.button = this.book.addWidget(new ChapterButton(this.book, ARTIFABRIANS_TABLE_ID, this.getToolX(), this.getToolY(), 12, 12));
    }

    @Override
    public void removeWidgets() {
        super.removeWidgets();
        if (this.button != null) {
            this.book.removeWidget((GuiEventListener)this.button);
        }
    }

    protected boolean hasSecondaryItem() {
        return ((FabrialOutputsElement)this.rightElement).hasSecondaryItem();
    }
}

