/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.resources.CraftingRecipesElement;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class CookingRecipesElement
extends ResourcesElement<RecipeData> {
    public CookingRecipesElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
    }

    @Override
    protected RecipeData loadResource(Book pBook, JsonElement pResourceJson) {
        if (pResourceJson.isJsonObject()) {
            return new RecipeData(pBook, pResourceJson.getAsJsonObject());
        }
        return new RecipeData(pBook, new ResourceLocation(pResourceJson.getAsString()));
    }

    @Override
    protected void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_292816_(OUTPUT_BACKGROUND_LOCATION, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Ingredient ingredient = (Ingredient)((RecipeData)this.resource).recipe.m_7527_().get(0);
        if (!ingredient.m_43947_()) {
            pGuiGraphics.m_280480_(ingredient.m_43908_()[this.tickCount / ((RecipeData)this.resource).interval % ingredient.m_43908_().length], -8, -8);
        }
    }

    public static class RecipeData
    extends CraftingRecipesElement.RecipeData {
        protected final ItemStack toastSymbol;
        protected final ResourceLocation id;

        public RecipeData(Book pBook, JsonObject pRecipeJson) {
            super(pBook, pRecipeJson);
            ItemStack itemStack;
            Recipe recipe = this.recipe;
            if (recipe instanceof AbstractCookingRecipe) {
                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe;
                itemStack = cookingRecipe.m_8042_();
            } else {
                itemStack = ItemStack.f_41583_;
            }
            this.toastSymbol = itemStack;
            this.id = pBook.getIdFromItem(((Ingredient)this.recipe.m_7527_().get(0)).m_43908_()[0].m_41720_());
        }

        public RecipeData(Book pBook, ResourceLocation pRecipeId) {
            super(pBook, pRecipeId);
            ItemStack itemStack;
            Recipe recipe = this.recipe;
            if (recipe instanceof AbstractCookingRecipe) {
                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe;
                itemStack = cookingRecipe.m_8042_();
            } else {
                itemStack = ItemStack.f_41583_;
            }
            this.toastSymbol = itemStack;
            this.id = pBook.getIdFromItem(((Ingredient)this.recipe.m_7527_().get(0)).m_43908_()[0].m_41720_());
        }

        public ItemStack getToastSymbol() {
            return this.toastSymbol;
        }

        @Override
        public ResourceLocation getResourceId() {
            return this.id;
        }
    }
}

