/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.resources.ResourcesElement;

public class NetheriteUpgradeElement
extends ResourcesElement<UpgradeData> {
    public static final ResourceLocation SMITHING_BACKGROUND_LOCATION = new ResourceLocation("stormward", "book/smithing_slots");
    private static final ItemStack TEMPLATE = new ItemStack((ItemLike)Items.f_265918_);
    private static final ItemStack ADDITION = new ItemStack((ItemLike)Items.f_42418_);

    public NetheriteUpgradeElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
    }

    @Override
    protected String getResourceKey() {
        return "upgrades";
    }

    @Override
    protected UpgradeData loadResource(Book pBook, JsonElement pResourceJson) {
        if (pResourceJson.isJsonObject()) {
            return new UpgradeData(pBook, pResourceJson.getAsJsonObject());
        }
        return new UpgradeData(pBook);
    }

    @Override
    protected void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_292816_(SMITHING_BACKGROUND_LOCATION, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.m_280480_(TEMPLATE, -26, -8);
        pGuiGraphics.m_280480_(((UpgradeData)this.resource).getBase(), -8, -8);
        pGuiGraphics.m_280480_(ADDITION, 10, -8);
    }

    public static class UpgradeData
    extends ResourcesElement.ResourceData {
        protected final ResourceLocation baseId;
        private final ItemStack base;
        private final ItemStack result;

        public UpgradeData(Book pBook, JsonObject pResourceJson) {
            super(pBook, pResourceJson);
            this.base = this.book.getItemStackFromString(pResourceJson.get("base").getAsString());
            this.baseId = this.book.getIdFromItem(this.base.m_41720_());
            this.result = this.book.getItemStackFromString(pResourceJson.get("result").getAsString());
        }

        public UpgradeData(Book pBook) {
            super(pBook);
            this.base = new ItemStack((ItemLike)Items.f_42388_);
            this.baseId = this.book.getIdFromItem(this.base.m_41720_());
            this.result = new ItemStack((ItemLike)Items.f_42393_);
        }

        public ItemStack getBase() {
            return this.base;
        }

        public ItemStack getResult() {
            return this.result;
        }

        @Override
        public ResourceLocation getResourceId() {
            return this.baseId;
        }
    }
}

