/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.element.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.element.resources.IsometricResourcesElement;
import us.amon.stormward.screen.book.element.resources.StructuresLevel;

public class StructuresElement
extends IsometricResourcesElement<StructureData> {
    private final StructuresLevel structureLevel;

    public StructuresElement(Book pBook, JsonElement pElementJson, int pWidth, int pHeight) {
        super(pBook, pElementJson, pWidth, pHeight);
        this.structureLevel = new StructuresLevel(((StructureData)this.resource).getBlockStates(), this.getBiomeFromResource((StructureData)this.resource));
    }

    @Override
    protected String getResourceKey() {
        return "structures";
    }

    @Override
    protected StructureData loadResource(Book pBook, JsonElement pResourceJson) {
        return new StructureData(pBook, pResourceJson.getAsJsonObject());
    }

    @Override
    protected float getDefaultSpin() {
        return 1.0f;
    }

    @Override
    protected void setResource(StructureData pResource) {
        super.setResource(pResource);
        this.structureLevel.setBlockStates(((StructureData)this.resource).getBlockStates());
        this.structureLevel.setBiome(this.getBiomeFromResource((StructureData)this.resource));
    }

    private Biome getBiomeFromResource(StructureData pData) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        return (Biome)((Holder.Reference)Minecraft.m_91087_().f_91073_.m_246945_(Registries.f_256952_).m_254902_(pData.getBiome()).orElseThrow()).get();
    }

    @Override
    protected void renderResource(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderResource(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280168_().m_252880_((float)(-((StructureData)this.resource).getWidth()) / 2.0f, (float)(-((StructureData)this.resource).getHeight()) / 2.0f, (float)(-((StructureData)this.resource).getDepth()) / 2.0f);
        this.structureLevel.render(pGuiGraphics);
    }

    public static class StructureData
    extends IsometricResourcesElement.IsometricResourceData {
        protected final BlockState[][][] blockStates;
        protected final int width;
        protected final int height;
        protected final int depth;
        protected final ResourceKey<Biome> biome;

        public StructureData(Book pBook, JsonObject pResourceJson) {
            super(pBook, pResourceJson);
            HashMap<Character, BlockState> mapping = new HashMap<Character, BlockState>();
            mapping.put(Character.valueOf(' '), Blocks.f_50016_.m_49966_());
            for (Map.Entry entry : pResourceJson.getAsJsonObject("states").entrySet()) {
                mapping.put(Character.valueOf(((String)entry.getKey()).charAt(0)), pBook.getStateFromString(((JsonElement)entry.getValue()).getAsString()));
            }
            JsonArray slices = pResourceJson.getAsJsonArray("shape");
            this.blockStates = new BlockState[slices.size()][][];
            for (int y = 0; y < slices.size(); ++y) {
                JsonArray slice = slices.get(slices.size() - 1 - y).getAsJsonArray();
                this.blockStates[y] = new BlockState[slice.size()][];
                for (int z = 0; z < slice.size(); ++z) {
                    String row = slice.get(z).getAsString();
                    this.blockStates[y][z] = new BlockState[row.length()];
                    for (int x = 0; x < row.length(); ++x) {
                        char key = row.charAt(x);
                        this.blockStates[y][z][x] = mapping.getOrDefault(Character.valueOf(key), Blocks.f_50016_.m_49966_());
                    }
                }
            }
            this.biome = pResourceJson.has("biome") ? ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(pResourceJson.get("biome").getAsString())) : Biomes.f_48202_;
            this.height = this.blockStates.length;
            this.depth = this.blockStates[0].length;
            this.width = this.blockStates[0][0].length;
        }

        @Override
        protected float getDefaultScale() {
            return 10.0f;
        }

        public BlockState[][][] getBlockStates() {
            return this.blockStates;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public ResourceKey<Biome> getBiome() {
            return this.biome;
        }
    }
}

