/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.icon;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.icon.BlockIcon;
import us.amon.stormward.screen.book.icon.EntityIcon;
import us.amon.stormward.screen.book.icon.ItemStackIcon;
import us.amon.stormward.screen.book.icon.SpriteIcon;

public abstract class Icon {
    public void tick() {
    }

    public abstract void render(GuiGraphics var1, int var2, int var3);

    public static Icon getIconFromJson(Book pBook, JsonObject pIconJson) {
        Icon icon = null;
        switch (pIconJson.get("type").getAsString()) {
            case "sprite": {
                icon = new SpriteIcon(pIconJson);
                break;
            }
            case "item": {
                icon = new ItemStackIcon(pBook, pIconJson);
                break;
            }
            case "block": {
                icon = new BlockIcon(pBook, pIconJson);
                break;
            }
            case "entity": {
                icon = new EntityIcon(pBook, pIconJson);
            }
        }
        return icon;
    }
}

