/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.screen.book.part;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import us.amon.stormward.screen.book.Book;
import us.amon.stormward.screen.book.chapter.Chapter;
import us.amon.stormward.screen.book.part.Part;

public class SingleChapterPart
extends Part {
    private final ResourceLocation chapterId;
    private final Chapter chapter;

    public SingleChapterPart(Book pBook, ResourceLocation pChapterId) {
        super(pBook);
        this.chapterId = pChapterId;
        this.chapter = pBook.getChapterFromId(this.chapterId);
    }

    @Override
    public boolean hasChapter(ResourceLocation pChapterId) {
        return pChapterId == this.chapterId;
    }

    @Override
    public ResourceLocation getCurrentChapter() {
        return this.chapterId;
    }

    @Override
    public List<ResourceLocation> getChapters() {
        return List.of(this.chapterId);
    }

    @Override
    public void tick() {
        this.chapter.tick();
    }

    @Override
    public void flipToFront() {
        this.chapter.flipToFront();
    }

    @Override
    public void flipToBack() {
        this.chapter.flipToBack();
    }

    @Override
    public void flipAway() {
        this.chapter.flipAway();
    }

    @Override
    public boolean hasNext() {
        return this.chapter.hasNext();
    }

    @Override
    public void next() {
        this.chapter.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.chapter.hasPrevious();
    }

    @Override
    public void previous() {
        this.chapter.previous();
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.chapter.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    public boolean mouseClicked(double pX, double pY, int pButton) {
        return this.chapter.mouseClicked(pX, pY, pButton);
    }
}

