/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import us.amon.stormward.mixin.accessor.ILevelRendererMixin;
import us.amon.stormward.util.ILocalPlayer;

public class ShadesmarSpecialEffects
extends DimensionSpecialEffects {
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("stormward", "textures/environment/sun_shadesmar.png");
    private static final ResourceLocation CLOUD_STREAK_LOCATION = new ResourceLocation("stormward", "textures/environment/cloud_streak.png");
    private static final Vec3 SKY_COLOR = new Vec3((double)0.149f, (double)0.1216f, (double)0.4f);
    private static final Vec3 FOG_COLOR = new Vec3((double)0.6863f, (double)0.4118f, (double)0.549f);

    public ShadesmarSpecialEffects() {
        this(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, true, false);
    }

    public ShadesmarSpecialEffects(float pCloudLevel, boolean pHasGround, DimensionSpecialEffects.SkyType pSkyType, boolean pForceBrightLightmap, boolean pConstantAmbientLight) {
        super(pCloudLevel, pHasGround, pSkyType, pForceBrightLightmap, pConstantAmbientLight);
    }

    @NotNull
    public Vec3 m_5927_(Vec3 pFogColor, float pBrightness) {
        return FOG_COLOR;
    }

    public float @Nullable [] m_7518_(float pTimeOfDay, float pPartialTicks) {
        return null;
    }

    public boolean m_5781_(int pX, int pY) {
        return false;
    }

    public boolean renderSky(@NotNull ClientLevel pLevel, int pTicks, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull Camera pCamera, @NotNull Matrix4f pProjectionMatrix, boolean pIsFoggy, Runnable pSetupFog) {
        ILocalPlayer localPlayer;
        LocalPlayer localPlayer2;
        FogType fogtype;
        pSetupFog.run();
        if (!(pIsFoggy || (fogtype = pCamera.m_167685_()) == FogType.POWDER_SNOW || fogtype == FogType.LAVA || (localPlayer2 = Minecraft.m_91087_().f_91074_) instanceof ILocalPlayer && (localPlayer = (ILocalPlayer)localPlayer2).stormward$isInCognitiveBeads() || this.doesMobEffectBlockSky(pCamera))) {
            Minecraft minecraft = Minecraft.m_91087_();
            FogRenderer.m_109036_();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)((float)ShadesmarSpecialEffects.SKY_COLOR.f_82479_), (float)((float)ShadesmarSpecialEffects.SKY_COLOR.f_82480_), (float)((float)ShadesmarSpecialEffects.SKY_COLOR.f_82481_), (float)1.0f);
            VertexBuffer skyBuffer = ((ILevelRendererMixin)minecraft.f_91060_).getSkyBuffer();
            ShaderInstance shaderinstance = RenderSystem.getShader();
            skyBuffer.m_85921_();
            skyBuffer.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance);
            VertexBuffer.m_85931_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            pPoseStack.m_85836_();
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(pLevel.m_46942_(pPartialTick) * 360.0f));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f sunMatrix = pPoseStack.m_85850_().m_252922_();
            float size = 20.0f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(sunMatrix, -size, 100.0f, -size).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(sunMatrix, size, 100.0f, -size).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(sunMatrix, size, 100.0f, size).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(sunMatrix, -size, 100.0f, size).m_7421_(0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CLOUD_STREAK_LOCATION);
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(((float)pTicks + pPartialTick) * 0.01f));
            size = 10.0f;
            float startY = -50.0f;
            float endY = 100.0f;
            float startZ = -110.0f;
            float endZ = -10.0f;
            float midPercent = 0.75f;
            float midY = startY + (endY - startY) * midPercent;
            float midZ = startZ + (endZ - startZ) * midPercent;
            for (int i = 0; i < 7; ++i) {
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_((float)(40 + i % 2 * 20)));
                Matrix4f cloudMatrix = pPoseStack.m_85850_().m_252922_();
                float offset = ((float)pTicks + pPartialTick) / 10000.0f + (float)i / 7.0f;
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                bufferbuilder.m_252986_(cloudMatrix, -size, startY, startZ).m_7421_(0.0f, 0.0f - offset).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_252986_(cloudMatrix, size, startY, startZ).m_7421_(1.0f, 0.0f - offset).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_252986_(cloudMatrix, size, midY, midZ).m_7421_(1.0f, midPercent - offset).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_252986_(cloudMatrix, -size, midY, midZ).m_7421_(0.0f, midPercent - offset).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_252986_(cloudMatrix, -size, midY, midZ).m_7421_(0.0f, midPercent - offset).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_252986_(cloudMatrix, size, midY, midZ).m_7421_(1.0f, midPercent - offset).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_252986_(cloudMatrix, size, endY, endZ).m_7421_(1.0f, 1.0f - offset).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_252986_(cloudMatrix, -size, endY, endZ).m_7421_(0.0f, 1.0f - offset).m_6122_(0, 0, 0, 255).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            }
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            pPoseStack.m_85849_();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (minecraft.f_91074_.m_20299_((float)pPartialTick).f_82480_ < pLevel.m_6106_().m_171687_((LevelHeightAccessor)pLevel)) {
                pPoseStack.m_85836_();
                pPoseStack.m_252880_(0.0f, 12.0f, 0.0f);
                VertexBuffer darkBuffer = ((ILevelRendererMixin)minecraft.f_91060_).getDarkBuffer();
                darkBuffer.m_85921_();
                darkBuffer.m_253207_(pPoseStack.m_85850_().m_252922_(), pProjectionMatrix, shaderinstance);
                VertexBuffer.m_85931_();
                pPoseStack.m_85849_();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    private boolean doesMobEffectBlockSky(Camera pCamera) {
        Entity entity = pCamera.m_90592_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.m_21023_(MobEffects.f_19610_) || livingentity.m_21023_(MobEffects.f_216964_);
    }

    public boolean renderClouds(@NotNull ClientLevel level, int ticks, float partialTick, @NotNull PoseStack poseStack, double camX, double camY, double camZ, @NotNull Matrix4f projectionMatrix) {
        return true;
    }
}

