/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import us.amon.stormward.worldgen.configuration.CrystalPillarConfiguration;

public class CrystalPillarFeature
extends Feature<CrystalPillarConfiguration> {
    public CrystalPillarFeature(Codec<CrystalPillarConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<CrystalPillarConfiguration> pContext) {
        WorldGenLevel level = pContext.m_159774_();
        BlockPos origin = pContext.m_159777_();
        RandomSource random = pContext.m_225041_();
        CrystalPillarConfiguration config = (CrystalPillarConfiguration)pContext.m_159778_();
        int height = config.heightProvider().m_214085_(random);
        float radius = config.radiusProvider().m_214084_(random);
        float taper = config.taperProvider().m_214084_(random);
        HashMap blocks = Maps.newHashMap();
        for (int y = -1; y < height; ++y) {
            this.placeLayer(origin.m_6630_(y), radius * (1.0f - (1.0f - taper) * (float)y / (float)height), random, blocks, y % 4 == 0, y > 0);
        }
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            level.m_7731_(pos, (Boolean)entry.getValue() != false ? config.ringProvider().m_213972_(random, pos) : config.baseProvider().m_213972_(random, pos), 19);
            BlockPos above = pos.m_7494_();
            if (blocks.containsKey(above) || !(random.m_188500_() <= (double)0.9f)) continue;
            level.m_7731_(above, config.topProvider().m_213972_(random, above), 19);
        }
        return false;
    }

    public void placeLayer(BlockPos pCenter, float pRadius, RandomSource pRandom, Map<BlockPos, Boolean> pBlocks, boolean pRing, boolean pCheckBelow) {
        int maxRadius = Mth.m_14167_((float)pRadius);
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                BlockPos pos = pCenter.m_7918_(x, 0, z);
                double rand = (double)pRadius + pRandom.m_188500_() - 0.5;
                if (!(pCenter.m_123331_((Vec3i)pos) <= rand * rand) || pCheckBelow && !pBlocks.containsKey(pos.m_7495_())) continue;
                pBlocks.put(pos, pRing);
            }
        }
    }
}

