/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.PerpendicularityBlock;

public class HotSpringFeature
extends Feature<Configuration> {
    public HotSpringFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> pContext) {
        BlockPos origin = pContext.m_159777_();
        WorldGenLevel level = pContext.m_159774_();
        RandomSource random = pContext.m_225041_();
        Configuration configuration = (Configuration)pContext.m_159778_();
        HashMap<BlockPos, Integer> spring = new HashMap<BlockPos, Integer>();
        int heightRange = configuration.heightRange.m_214085_(random);
        int minArea = configuration.minArea.m_214085_(random);
        int maxArea = configuration.maxArea.m_214085_(random);
        for (int i = heightRange - 1; i >= 0 && !this.getSurface(origin.m_6630_(i), spring, level, minArea, maxArea); --i) {
            spring.clear();
        }
        if (spring.size() < minArea) {
            return false;
        }
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        for (Map.Entry entry : spring.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            queue.add((BlockPos)entry.getKey());
        }
        int steepness = configuration.steepness.m_214085_(random);
        HashSet<BlockPos> feather = new HashSet<BlockPos>();
        int maxDepth = 0;
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.remove();
            int depth = (Integer)spring.get(pos);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = pos.m_121945_(direction);
                Integer neighborDepth = (Integer)spring.get(neighbor);
                if (neighborDepth == null || neighborDepth <= depth) continue;
                if (neighborDepth >= Integer.MAX_VALUE) {
                    queue.add(neighbor);
                    spring.put(neighbor, depth + steepness);
                    continue;
                }
                feather.add(neighbor);
            }
            maxDepth = depth;
        }
        boolean perpendicularity = random.m_188501_() <= configuration.perpendicularityChance();
        int perpDepth = Math.max(0, (int)((float)maxDepth * 0.7f));
        for (Map.Entry entry : spring.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            int depth = (Integer)entry.getValue();
            if (depth <= 0) {
                this.safeReplaceBlock(level, pos, configuration.edge().m_213972_(random, pos));
                depth = 1;
            } else {
                if (steepness > 1 && feather.contains(pos)) {
                    depth -= 1 + random.m_188503_(steepness - 1);
                }
                for (int i = 0; i < depth; ++i) {
                    BlockPos below = pos.m_6625_(i);
                    if (perpendicularity && i == perpDepth) {
                        this.safeReplaceBlock(level, below, (BlockState)((PerpendicularityBlock)((Object)StormwardBlocks.PERPENDICULARITY.get())).m_49966_().m_61124_((Property)PerpendicularityBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                        continue;
                    }
                    this.safeReplaceBlock(level, below, Blocks.f_49990_.m_49966_());
                }
            }
            int wallDepth = Math.min((Integer)entry.getValue() + steepness, maxDepth + 1);
            for (int i = depth; i < wallDepth; ++i) {
                BlockPos below = pos.m_6625_(i);
                this.safeReplaceBlock(level, below, configuration.wall().m_213972_(random, below));
            }
        }
        return true;
    }

    private boolean getSurface(BlockPos pLayerOrigin, Map<BlockPos, Integer> pSpring, WorldGenLevel pLevel, int minArea, int maxArea) {
        int chunkX = this.getChunkX(pLayerOrigin);
        int chunkZ = this.getChunkZ(pLayerOrigin);
        Stack<BlockPos> stack = new Stack<BlockPos>();
        stack.push(pLayerOrigin);
        while (!stack.isEmpty()) {
            BlockPos pos = (BlockPos)stack.pop();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = pos.m_121945_(direction);
                if (pSpring.size() > maxArea || !this.isChunkInBounds(neighbor, chunkX, chunkZ)) {
                    return false;
                }
                if (pSpring.containsKey(neighbor)) continue;
                if (pLevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, neighbor.m_123341_(), neighbor.m_123343_()) <= neighbor.m_123342_()) {
                    stack.push(neighbor);
                    pSpring.put(neighbor, Integer.MAX_VALUE);
                    continue;
                }
                pSpring.put(neighbor, 0);
            }
        }
        return pSpring.size() >= minArea;
    }

    private boolean isChunkInBounds(BlockPos pPos, int pChunkX, int pChunkZ) {
        return Math.abs(this.getChunkX(pPos) - pChunkX) <= 1 && Math.abs(this.getChunkZ(pPos) - pChunkZ) <= 1;
    }

    private int getChunkX(BlockPos pPos) {
        return pPos.m_123341_() >> 4;
    }

    private int getChunkZ(BlockPos pPos) {
        return pPos.m_123343_() >> 4;
    }

    private void safeReplaceBlock(WorldGenLevel pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_8055_(pPos).m_204336_(BlockTags.f_144287_)) {
            pLevel.m_7731_(pPos, pState, 2);
            this.m_159739_(pLevel, pPos);
        }
    }

    public record Configuration(IntProvider heightRange, IntProvider minArea, IntProvider maxArea, IntProvider steepness, BlockStateProvider edge, BlockStateProvider wall, float perpendicularityChance) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.f_146531_.fieldOf("heightRange").forGetter(Configuration::minArea), (App)IntProvider.f_146531_.fieldOf("minArea").forGetter(Configuration::minArea), (App)IntProvider.f_146531_.fieldOf("maxArea").forGetter(Configuration::maxArea), (App)IntProvider.f_146531_.fieldOf("steepness").forGetter(Configuration::steepness), (App)BlockStateProvider.f_68747_.fieldOf("edge").forGetter(Configuration::edge), (App)BlockStateProvider.f_68747_.fieldOf("wall").forGetter(Configuration::wall), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("perpendicularity_chance").forGetter(Configuration::perpendicularityChance)).apply((Applicative)instance, Configuration::new));
    }
}

