/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.plant.IRosharanPlant;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.tag.StormwardBlockTags;

public class PurelakeFeature
extends Feature<Configuration> {
    public PurelakeFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<Configuration> pContext) {
        BlockPos center = pContext.m_159777_();
        WorldGenLevel level = pContext.m_159774_();
        RandomSource random = pContext.m_225041_();
        Configuration configuration = (Configuration)pContext.m_159778_();
        int border = 3;
        int width = configuration.width().m_214085_(random);
        int range = width + border * 2;
        boolean[] lake = new boolean[range * range];
        int tries = random.m_188503_(4) + 4;
        for (int i = 0; i < tries; ++i) {
            double xRand1 = random.m_188500_() * 6.0 + 3.0;
            double zRand1 = random.m_188500_() * 6.0 + 3.0;
            double xRand2 = random.m_188500_() * (16.0 - xRand1 - 2.0) + 1.0 + xRand1 / 2.0;
            double zRand2 = random.m_188500_() * (16.0 - zRand1 - 2.0) + 1.0 + zRand1 / 2.0;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < width; ++z) {
                    double xDist = ((double)x * 16.0 / (double)width - xRand2) / (xRand1 / 2.0);
                    double zDist = ((double)z * 16.0 / (double)width - zRand2) / (zRand1 / 2.0);
                    double dist = xDist * xDist + zDist * zDist;
                    if (!(dist < 1.0)) continue;
                    lake[(x + border) * range + (z + border)] = true;
                }
            }
        }
        int xCorner = center.m_123341_() - range / 2;
        int zCorner = center.m_123343_() - range / 2;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockState fluid = configuration.fluid().m_213972_(random, center);
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        HashMap<Integer, Integer> distances = new HashMap<Integer, Integer>();
        int i = range / 2 * range + range / 2;
        queue.addFirst(i);
        distances.put(i, 0);
        while (!queue.isEmpty()) {
            int lakeHeight;
            i = (Integer)queue.pop();
            int x = i / range;
            int z = i % range;
            int val = (Integer)distances.get(i);
            int height = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, xCorner + x, zCorner + z);
            boolean barrier = false;
            if (lake[i]) {
                lakeHeight = configuration.height().m_214085_(random);
                boolean lakeEast = lake[(x + 1) * range + z];
                boolean lakeWest = lake[(x - 1) * range + z];
                boolean lakeSouth = lake[x * range + z + 1];
                boolean lakeNorth = lake[x * range + z - 1];
                boolean bl = barrier = !lakeEast || !lakeWest || !lakeSouth || !lakeNorth;
                if (lakeEast) {
                    this.addLake(queue, distances, (x + 1) * range + z);
                } else {
                    this.addWall(queue, distances, (x + 1) * range + z, 1);
                }
                if (lakeWest) {
                    this.addLake(queue, distances, (x - 1) * range + z);
                } else {
                    this.addWall(queue, distances, (x - 1) * range + z, 1);
                }
                if (lakeSouth) {
                    this.addLake(queue, distances, x * range + z + 1);
                } else {
                    this.addWall(queue, distances, x * range + z + 1, 1);
                }
                if (lakeNorth) {
                    this.addLake(queue, distances, x * range + z - 1);
                } else {
                    this.addWall(queue, distances, x * range + z - 1, 1);
                }
            } else {
                if (val > border) continue;
                lakeHeight = Mth.m_269140_((float)((float)val / (float)(border + 1)), (int)configuration.height().m_214085_(random), (int)height);
                if (x < range - 1) {
                    this.addWall(queue, distances, (x + 1) * range + z, val + 1);
                }
                if (x > 0) {
                    this.addWall(queue, distances, (x - 1) * range + z, val + 1);
                }
                if (z < range - 1) {
                    this.addWall(queue, distances, x * range + z + 1, val + 1);
                }
                if (z > 0) {
                    this.addWall(queue, distances, x * range + z - 1, val + 1);
                }
            }
            if (!this.adjustHeight(level, configuration, random, pos, xCorner + x, zCorner + z, height, lakeHeight, fluid)) continue;
            pos.m_122178_(xCorner + x, lakeHeight, zCorner + z);
            if (lake[i]) {
                if (barrier && !this.isBarrierNecessary(level, (BlockPos)pos)) {
                    barrier = false;
                }
                if (barrier) {
                    this.replaceBlock(level, (BlockPos)pos, configuration.barrier().m_213972_(random, (BlockPos)pos));
                    continue;
                }
                this.replaceBlock(level, (BlockPos)pos, fluid);
                if (height < lakeHeight) {
                    this.replaceBlock(level, (BlockPos)pos.m_122178_(xCorner + x, lakeHeight - 1, zCorner + z), fluid);
                }
                this.replaceBlock(level, pos.m_7495_(), configuration.floor().m_213972_(random, pos.m_7495_()));
                continue;
            }
            if (lakeHeight <= height || level.m_8055_(pos.m_7494_()).m_60713_(fluid.m_60734_())) continue;
            this.replaceBlock(level, (BlockPos)pos, configuration.wall().m_213972_(random, (BlockPos)pos));
        }
        return true;
    }

    private void addLake(Deque<Integer> pDeque, Map<Integer, Integer> pMap, int pI) {
        if (!pMap.containsKey(pI)) {
            pDeque.addFirst(pI);
            pMap.put(pI, 0);
        }
    }

    private void addWall(Deque<Integer> pDeque, Map<Integer, Integer> pMap, int pI, int pVal) {
        if (!pMap.containsKey(pI)) {
            pDeque.addLast(pI);
            pMap.put(pI, pVal);
        }
    }

    private boolean adjustHeight(WorldGenLevel pLevel, Configuration pConfig, RandomSource pRandom, BlockPos.MutableBlockPos pPos, int pX, int pZ, int pCurrentHeight, int pDesiredHeight, BlockState pFluid) {
        BlockState belowState;
        int y;
        if (pCurrentHeight > pDesiredHeight) {
            this.m_159739_(pLevel, (BlockPos)pPos.m_122178_(pX, pCurrentHeight, pZ));
        } else {
            this.m_159739_(pLevel, (BlockPos)pPos.m_122178_(pX, pDesiredHeight - 1, pZ));
        }
        for (y = pCurrentHeight; y > pDesiredHeight; --y) {
            if (this.replaceBlock(pLevel, (BlockPos)pPos.m_122178_(pX, y, pZ), Blocks.f_50016_.m_49966_())) continue;
            return false;
        }
        if (pCurrentHeight > pDesiredHeight && (belowState = pLevel.m_8055_(pPos.m_7495_())).m_60713_((Block)StormwardBlocks.STONE_GRASS_BLOCK.get())) {
            pLevel.m_7731_(pPos.m_7495_(), (BlockState)belowState.m_61124_(IRosharanPlant.PLANT_REACTION, (Comparable)((Object)PlantReaction.EXTENDED)), 2);
        }
        for (y = pDesiredHeight - 1; y >= pCurrentHeight; --y) {
            pPos.m_122178_(pX, y, pZ);
            boolean floor = y > 63 && pLevel.m_8055_(pPos.m_7494_()).m_60713_(pFluid.m_60734_());
            if (this.replaceBlock(pLevel, (BlockPos)pPos, floor ? pConfig.floor().m_213972_(pRandom, (BlockPos)pPos) : pConfig.wall().m_213972_(pRandom, (BlockPos)pPos))) continue;
            return false;
        }
        return true;
    }

    private boolean isBarrierNecessary(WorldGenLevel pLevel, BlockPos pPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!pLevel.m_8055_(pPos.m_121945_(direction)).m_60795_()) continue;
            return true;
        }
        return false;
    }

    private boolean replaceBlock(WorldGenLevel pLevel, BlockPos pPos, BlockState pState) {
        if (this.canReplaceBlock(pLevel.m_8055_(pPos))) {
            pLevel.m_7731_(pPos, pState, 2);
            return true;
        }
        return false;
    }

    private boolean canReplaceBlock(BlockState pState) {
        return !pState.m_204336_(StormwardBlockTags.PURELAKE_CANNOT_REPLACE);
    }

    public record Configuration(IntProvider height, IntProvider width, BlockStateProvider fluid, BlockStateProvider barrier, BlockStateProvider wall, BlockStateProvider floor) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.f_146531_.fieldOf("height").forGetter(Configuration::height), (App)IntProvider.f_146531_.fieldOf("width").forGetter(Configuration::width), (App)BlockStateProvider.f_68747_.fieldOf("fluid").forGetter(Configuration::fluid), (App)BlockStateProvider.f_68747_.fieldOf("barrier").forGetter(Configuration::barrier), (App)BlockStateProvider.f_68747_.fieldOf("wall").forGetter(Configuration::wall), (App)BlockStateProvider.f_68747_.fieldOf("floor").forGetter(Configuration::floor)).apply((Applicative)instance, Configuration::new));
    }
}

