/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class StructureFeature
extends Feature<Configuration> {
    public StructureFeature(Codec<Configuration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<Configuration> pContext) {
        RandomSource random = pContext.m_225041_();
        WorldGenLevel level = pContext.m_159774_();
        BlockPos origin = pContext.m_159777_();
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        Configuration config = (Configuration)pContext.m_159778_();
        StructureTemplateManager structuretemplatemanager = level.m_6018_().m_7654_().m_236738_();
        ResourceLocation structure = config.structures.get(random.m_188503_(config.structures.size()));
        StructureTemplate template = structuretemplatemanager.m_230359_(structure);
        ChunkPos chunk = new ChunkPos(origin);
        BoundingBox boundingBox = new BoundingBox(chunk.m_45604_() - 16, level.m_141937_(), chunk.m_45605_() - 16, chunk.m_45608_() + 16, level.m_151558_(), chunk.m_45609_() + 16);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74381_(boundingBox).m_230324_(random);
        Vec3i vec3i = template.m_163808_(rotation);
        BlockPos pos = origin.m_7918_(-vec3i.m_123341_() / 2, 0, -vec3i.m_123343_() / 2);
        int y = origin.m_123342_();
        for (int k = 0; k < vec3i.m_123341_(); ++k) {
            for (int l = 0; l < vec3i.m_123343_(); ++l) {
                y = Math.min(y, level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_() + k, pos.m_123343_() + l));
            }
        }
        BlockPos structurePos = template.m_74583_(pos.m_175288_(y = Math.max(y - 15 - random.m_188503_(10), level.m_141937_() + 10)), Mirror.NONE, rotation);
        if (StructureFeature.countEmptyCorners(level, template.m_74633_(settings, structurePos)) > config.maxEmptyCorners) {
            return false;
        }
        settings.m_74394_();
        ((StructureProcessorList)config.processors.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)settings).m_74383_(arg_0));
        template.m_230328_((ServerLevelAccessor)level, structurePos, structurePos, settings, random, 4);
        return true;
    }

    private static int countEmptyCorners(WorldGenLevel pLevel, BoundingBox pBoundingBox) {
        MutableInt mutableint = new MutableInt(0);
        pBoundingBox.m_162380_(p_284921_ -> {
            BlockState blockstate = pLevel.m_8055_(p_284921_);
            if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49991_) || blockstate.m_60713_(Blocks.f_49990_)) {
                mutableint.add(1);
            }
        });
        return mutableint.getValue();
    }

    public record Configuration(List<ResourceLocation> structures, Holder<StructureProcessorList> processors, int maxEmptyCorners) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("structures").forGetter(getter -> getter.structures), (App)StructureProcessorType.f_74468_.fieldOf("processors").forGetter(getter -> getter.processors), (App)Codec.intRange((int)0, (int)7).fieldOf("max_empty_corners").forGetter(getter -> getter.maxEmptyCorners)).apply((Applicative)instance, Configuration::new));
    }
}

