/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.worldgen.tree;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.worldgen.provider.TwoStateProvider;
import us.amon.stormward.worldgen.tree.StormwardTrunkPlacers;

public class StumpweightTrunkPlacer
extends TrunkPlacer {
    public static final Codec<StumpweightTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> StumpweightTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, StumpweightTrunkPlacer::new));

    public StumpweightTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)StormwardTrunkPlacers.STUMPWEIGHT.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader pLevel, @NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, int pFreeTreeHeight, @NotNull BlockPos pPos, @NotNull TreeConfiguration pConfig) {
        int height;
        StumpweightTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_(), (TreeConfiguration)pConfig);
        TwoStateProvider trunkProvider = (TwoStateProvider)pConfig.f_68185_;
        for (height = 0; height < pFreeTreeHeight; ++height) {
            BlockPos trunkPos = pPos.m_6630_(height);
            if (!this.m_213554_(pLevel, trunkPos)) {
                --height;
                break;
            }
            pBlockSetter.accept(trunkPos, height < pFreeTreeHeight - 1 ? trunkProvider.getFirstState(pRandom, trunkPos) : trunkProvider.getSecondState(pRandom, trunkPos));
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pPos.m_121945_(Direction.WEST), height, false));
    }
}

