/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import us.amon.stormward.item.StormwardCreativeModeTabs;

@Mod.EventBusSubscriber(modid="stormward", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> SHARDBLADE_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Integer> SHARDBLADE_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Double> SHARDHAMMER_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Integer> SHARDHAMMER_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> GRANDBOW_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> HALF_SHARD_SHIELD_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> AUGMENTED_PICKAXE_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> AUGMENTED_AXE_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> AUGMENTED_SHOVEL_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> AUGMENTED_HOE_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> ASCENDER_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> ESSENCE_DETECTOR_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Double> SHARDPLATE_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Integer> SHARDPLATE_STORMLIGHT_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Integer> CONJOINED_BLOCK_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> REVERSED_BLOCK_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> OATHGATE_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> SPANSWITCH_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> CULTIVATOR_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Double> HIGHSTORM_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Integer> HIGHSTORM_STORMLIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> ROSHAR_REGION_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> SHATTERED_PLAINS_REGION_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Integer> PLATEAU_RUN_SPAWN_INTERVAL;
    public static final ForgeConfigSpec.ConfigValue<Integer> SPREN_SPAWN_ATTEMPTS;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_SPREN_PER_CHUNK;

    @SubscribeEvent
    public static void onConfigReloading(ModConfigEvent.Reloading event) {
        StormwardCreativeModeTabs.onConfigReloading();
    }

    static {
        BUILDER.push("Stormward Configuration");
        SHARDBLADE_DAMAGE = BUILDER.comment("Additional damage dealt by Shardblades").defineInRange("Shardblade Damage Bonus", 8.0, 0.0, 1000.0);
        SHARDBLADE_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Shardblade").defineInRange("Shardblade Stormlight", 100, 1, 1000);
        SHARDHAMMER_DAMAGE = BUILDER.comment("Additional damage dealt by Shardhammers").defineInRange("Shardhammer Damage Bonus", 7.0, 0.0, 1000.0);
        SHARDHAMMER_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Shardhammer").defineInRange("Shardhammer Stormlight", 100, 1, 1000);
        GRANDBOW_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Grandbow").defineInRange("Grandbow Stormlight", 100, 1, 1000);
        HALF_SHARD_SHIELD_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Half-Shard Shield").defineInRange("Half-Shard Shield Stormlight", 100, 1, 1000);
        AUGMENTED_PICKAXE_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Augmented Pickaxe").defineInRange("Augmented Pickaxe Stormlight", 100, 1, 1000);
        AUGMENTED_AXE_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Augmented Axe").defineInRange("Augmented Axe Stormlight", 100, 1, 1000);
        AUGMENTED_SHOVEL_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Augmented Shovel").defineInRange("Augmented Shovel Stormlight", 100, 1, 1000);
        AUGMENTED_HOE_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Augmented Hoe").defineInRange("Augmented Hoe Stormlight", 100, 1, 1000);
        ASCENDER_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in an Ascender").defineInRange("Ascender Stormlight", 100, 1, 1000);
        ESSENCE_DETECTOR_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in an Essence Detector").defineInRange("Essence Detector Stormlight", 100, 1, 1000);
        SHARDPLATE_DAMAGE = BUILDER.comment("Additional damage per worn piece of Shardplate").defineInRange("Shardplate Damage Bonus", 1.0, 0.0, 300.0);
        SHARDPLATE_STORMLIGHT_MULTIPLIER = BUILDER.comment("Multiplied by base durability for a given piece of Shardplate to determine its maximum amount of Stormlight").defineInRange("Shardplate Stormlight Multiplier", 8, 1, 100);
        CONJOINED_BLOCK_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Conjoined Block").defineInRange("Conjoined Block Stormlight", 100, 1, 1000);
        REVERSED_BLOCK_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Reversed Block").defineInRange("Reversed Block Stormlight", 100, 1, 1000);
        OATHGATE_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in an Oathgate").defineInRange("Oathgate Stormlight", 100, 1, 1000);
        SPANSWITCH_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Spanswitch").defineInRange("Spanswitch Stormlight", 100, 1, 1000);
        CULTIVATOR_STORMLIGHT = BUILDER.comment("Maximum amount of Stormlight contained in a Cultivator").defineInRange("Cultivator Stormlight", 100, 1, 1000);
        HIGHSTORM_DAMAGE = BUILDER.comment("Damage dealt by a Highstorm every damage tick").defineInRange("Highstorm Damage", 1.0, 1.0, 50.0);
        HIGHSTORM_STORMLIGHT = BUILDER.comment("Amount of Stormlight imbued into items per Highstorm tick").defineInRange("Highstorm Stormlight", 1, 0, 100);
        ROSHAR_REGION_WEIGHT = BUILDER.comment("Relative frequency of Rosharan biomes compared to Shattered Plains and other mods' TerraBlender regions").worldRestart().defineInRange("Roshar Region Weight", 5, 1, Integer.MAX_VALUE);
        SHATTERED_PLAINS_REGION_WEIGHT = BUILDER.comment("Relative frequency of Shattered Plains biomes compared to Rosharan biomes and other mods' TerraBlender regions").worldRestart().defineInRange("Shattered Plains Region Weight", 1, 1, Integer.MAX_VALUE);
        PLATEAU_RUN_SPAWN_INTERVAL = BUILDER.comment("Time in ticks between Plateau Run spawn attempts").defineInRange("Plateau Run Spawn Interval", 36000, 600, Integer.MAX_VALUE);
        SPREN_SPAWN_ATTEMPTS = BUILDER.comment("Number of attempts to spawn a natural spren per tick, higher values may cause lag").defineInRange("Spren Spawn Attempts Per Tick", 1, 0, 100);
        MAX_SPREN_PER_CHUNK = BUILDER.comment("Maximum number of spren in a single chunk, higher values may cause lag").defineInRange("Max Spren Per Chunk", 16, 0, 100);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

