/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.attribute;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class StormwardAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"stormward");
    public static final RegistryObject<Attribute> JUMP_HEIGHT_ADDITION = ATTRIBUTES.register("jump_height_addition", () -> new RangedAttribute("attribute.stormward.jump_height", 0.0, 0.0, 512.0).m_22084_(true));

    public static void register(IEventBus eventBus) {
        ATTRIBUTES.register(eventBus);
    }

    public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)JUMP_HEIGHT_ADDITION.get());
    }

    public static double jumpHeightToDelta(double pHeight) {
        return pHeight <= 0.0 ? 0.0 : 0.0121 + 0.157 * pHeight - 0.00786 * pHeight * pHeight;
    }

    public static void onLivingJump(LivingEntity pEntity) {
        AttributeInstance jumpHeight;
        if ((!pEntity.m_9236_().f_46443_ || pEntity instanceof Player) && (jumpHeight = pEntity.m_21051_((Attribute)JUMP_HEIGHT_ADDITION.get())) != null) {
            pEntity.m_246865_(new Vec3(0.0, StormwardAttributes.jumpHeightToDelta(jumpHeight.m_22135_()), 0.0));
        }
    }

    public static void onLivingFall(LivingFallEvent pEvent) {
        AttributeInstance jumpHeight = pEvent.getEntity().m_21051_((Attribute)JUMP_HEIGHT_ADDITION.get());
        if (jumpHeight != null) {
            pEvent.setDistance((float)Math.max(0.0, (double)pEvent.getDistance() - jumpHeight.m_22135_()));
        }
    }
}

