/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.blockentity.DuelingPitEntity;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.entity.duel.Duel;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.level.Duels;

public class DuelingPitBlock
extends BaseEntityBlock {
    public static final int ARENA_RADIUS = 12;
    public static final int ARENA_HEIGHT = 8;
    public static final int MAX_PLAYERS = 4;
    public static final BooleanProperty BOUNDS_VISIBLE = BooleanProperty.m_61465_((String)"bounds_visible");
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;

    protected DuelingPitBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BOUNDS_VISIBLE, (Comparable)Boolean.FALSE)).m_61124_((Property)ACTIVE, (Comparable)Boolean.FALSE)).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BOUNDS_VISIBLE, ACTIVE, OPEN});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (pHand == InteractionHand.MAIN_HAND && (blockEntity = pLevel.m_7702_(pPos)) instanceof DuelingPitEntity) {
            DuelingPitEntity entity = (DuelingPitEntity)blockEntity;
            if (pPlayer.m_36341_()) {
                if (!pLevel.f_46443_) {
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BOUNDS_VISIBLE, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)BOUNDS_VISIBLE) == false)), 3);
                }
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            ItemStack stack = pPlayer.m_21120_(pHand);
            if (stack.m_150930_((Item)StormwardItems.SAPPHIRE.get())) {
                if (!entity.empty) {
                    if (!pLevel.f_46443_) {
                        if (!pPlayer.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        entity.popOutItem();
                    }
                    return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
                }
            } else {
                ArenaStatus status = DuelingPitBlock.getArenaStatus(pLevel, pPos);
                if (!pLevel.f_46443_) {
                    if (status == ArenaStatus.VALID) {
                        entity.startDuel((ServerLevel)pLevel);
                    }
                } else if (status != ArenaStatus.VALID) {
                    pPlayer.m_5661_(status.getErrorMessage(), true);
                }
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return ((BlockEntityType)StormwardBlockEntities.DUELING_PIT.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return DuelingPitBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)StormwardBlockEntities.DUELING_PIT.get()), DuelingPitEntity::tick);
    }

    public float m_5880_(BlockState pState, @NotNull Player pPlayer, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return (Boolean)pState.m_61143_((Property)ACTIVE) != false ? 0.0f : super.m_5880_(pState, pPlayer, pLevel, pPos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? 3600000.0f : super.getExplosionResistance(state, level, pos, explosion);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        super.onBlockStateChange(level, pos, oldState, newState);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DuelingPitEntity) {
            DuelingPitEntity entity = (DuelingPitEntity)blockEntity;
            entity.onBlockStateChange(level, pos, oldState, newState);
        }
    }

    public void m_6810_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pNewState, boolean pMovedByPiston) {
        ServerLevel serverLevel;
        Duel duel;
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        if (!pNewState.m_60713_(pState.m_60734_()) && pLevel instanceof ServerLevel && (duel = Duels.get(serverLevel = (ServerLevel)pLevel).getByPos(pPos)) != null) {
            duel.stop();
        }
    }

    public static boolean isInArena(BlockPos pCenter, Vec3 pOtherPos) {
        return DuelingPitBlock.isInArenaHorizontal(pCenter, pOtherPos) && pOtherPos.m_7098_() >= (double)pCenter.m_123342_() && pOtherPos.m_7098_() < (double)(pCenter.m_123342_() + 8);
    }

    public static boolean isInArena(BlockPos pCenter, Vec3i pOtherPos) {
        return DuelingPitBlock.isInArena(pCenter, Vec3.m_82528_((Vec3i)pOtherPos));
    }

    public static boolean isInArena(BlockPos pCenter, Entity pEntity) {
        return DuelingPitBlock.isInArena(pCenter, (Vec3i)pEntity.m_20183_());
    }

    public static boolean isInArenaHorizontal(BlockPos pCenter, Vec3 pOtherPos) {
        return pCenter.m_203202_(pOtherPos.m_7096_(), (double)pCenter.m_123342_(), pOtherPos.m_7094_()) < 132.25;
    }

    public static boolean isInArenaHorizontal(BlockPos pCenter, Vec3i pOtherPos) {
        return DuelingPitBlock.isInArenaHorizontal(pCenter, Vec3.m_82528_((Vec3i)pOtherPos));
    }

    public static boolean isInArenaHorizontal(BlockPos pCenter, Entity pEntity) {
        return DuelingPitBlock.isInArenaHorizontal(pCenter, pEntity.m_20182_());
    }

    public static boolean isArenaObstructed(Level pLevel, BlockPos pCenter) {
        return DuelingPitBlock.getBlockStream(pCenter, 0, 7).anyMatch(pos -> !pos.equals((Object)pCenter) && !pLevel.m_8055_(pos).m_60795_());
    }

    public static boolean isArenaUnstable(Level pLevel, BlockPos pCenter) {
        return DuelingPitBlock.getBlockStream(pCenter, -1, -1).anyMatch(pos -> !pLevel.m_8055_(pos).m_60659_((BlockGetter)pLevel, pos, Direction.UP, SupportType.FULL));
    }

    public static Stream<BlockPos> getBlockStream(BlockPos pCenter, int pMinHeight, int pMaxHeight) {
        return BlockPos.m_121990_((BlockPos)pCenter.m_7918_(-12, pMinHeight, -12), (BlockPos)pCenter.m_7918_(12, pMaxHeight, 12)).filter(pos -> DuelingPitBlock.isInArenaHorizontal(pCenter, (Vec3i)pos));
    }

    public static List<LivingEntity> getLivingEntitiesInArena(Level pLevel, BlockPos pPos) {
        return DuelingPitBlock.getEntitiesInArena(pLevel, pPos, LivingEntity.class, entity -> entity.m_6084_() && !entity.m_5833_() && DuelingPitBlock.isInArenaHorizontal(pPos, (Entity)entity));
    }

    public static <T extends Entity> List<T> getEntitiesInArena(Level pLevel, BlockPos pPos, Class<T> pClass, Predicate<? super T> pPredicate) {
        AABB aabb = new AABB(pPos.m_7918_(-12, 0, -12), pPos.m_7918_(12, 7, 12));
        return pLevel.m_6443_(pClass, aabb, pPredicate);
    }

    public static ArenaStatus getArenaStatus(Level pLevel, BlockPos pPos) {
        if (DuelingPitBlock.isArenaObstructed(pLevel, pPos)) {
            return ArenaStatus.OBSTRUCTED;
        }
        if (DuelingPitBlock.isArenaUnstable(pLevel, pPos)) {
            return ArenaStatus.UNSTABLE;
        }
        int players = 0;
        for (LivingEntity entity : DuelingPitBlock.getLivingEntitiesInArena(pLevel, pPos)) {
            if (entity instanceof Player && ++players > 4) {
                return ArenaStatus.UNFAIR;
            }
            if (!(entity instanceof Mob)) continue;
            return ArenaStatus.CROWDED;
        }
        return ArenaStatus.VALID;
    }

    public static enum ArenaStatus {
        VALID(""),
        OBSTRUCTED("event.stormward.duel.arena.obstructed"),
        UNSTABLE("event.stormward.duel.arena.unstable"),
        CROWDED("event.stormward.duel.arena.crowded"),
        UNFAIR("event.stormward.duel.arena.unfair");

        private final Component errorMessage;

        private ArenaStatus(String pKey) {
            this.errorMessage = Component.m_237115_((String)pKey);
        }

        public Component getErrorMessage() {
            return this.errorMessage;
        }
    }
}

