/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.pairedfabrial;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.Config;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.pairedfabrial.PairedBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.pairedfabrial.OathgateBlockEntity;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.command.StormwardGameRules;
import us.amon.stormward.entity.spren.shadesmar.OathgateSpren;
import us.amon.stormward.entity.spren.shadesmar.OathgateSprenVariant;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.network.ClientboundRotatePlayerPacket;
import us.amon.stormward.network.PacketHandler;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.sound.StormwardSoundEvents;
import us.amon.stormward.worldgen.dimension.StormwardDimensions;
import us.amon.stormward.worldgen.portal.ShadesmarTeleporter;

public class OathgateBlock
extends PairedBlock<OathgateBlockEntity> {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final int PLATFORM_RADIUS = 6;
    public static final int PLATFORM_OFFSET = 2;
    private static final int SPREN_X = 4;
    private static final int SPREN_Y = 3;
    private static final int SPREN_Z = 4;
    private static final int COST_PER_ENTITY = 2;

    public OathgateBlock(BlockBehaviour.Properties pProperties) {
        super(Config.OATHGATE_STORMLIGHT, StormwardBlockEntities.OATHGATE, pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)DUN, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, DUN});
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        OathgateBlockEntity oathgateEntity;
        BlockEntity blockEntity;
        if (pPlayer.m_21120_(pHand).m_150930_((Item)StormwardItems.TUNING_FORK.get())) {
            return pLevel.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (pHand == InteractionHand.MAIN_HAND && pPlayer.m_21120_(pHand).m_41619_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof OathgateBlockEntity && !StormlightStorageHelper.isDun((ICapabilityProvider)(oathgateEntity = (OathgateBlockEntity)blockEntity)) && (pPlayer.m_36341_() ? this.swapDimensions(pState, pLevel, pPos, oathgateEntity) : this.teleport(pState, pLevel, pPos, oathgateEntity))) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void explode(Level pLevel, BlockPos pPos) {
        Vec3 center = pPos.m_252807_();
        pLevel.m_254951_(null, pLevel.m_269111_().m_269488_(center), null, center, 1.5f, true, Level.ExplosionInteraction.BLOCK);
        pLevel.m_46961_(pPos, true);
    }

    protected boolean swapDimensions(BlockState pState, Level pLevel, BlockPos pPos, OathgateBlockEntity pOathgate) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (!pOathgate.tryCreateMirror(serverLevel)) {
                this.explode((Level)serverLevel, pPos);
                return false;
            }
            ServerLevel destination = OathgateBlock.getDestination(serverLevel);
            ShadesmarTeleporter teleporter = new ShadesmarTeleporter(pPos, pOathgate.getMirrorPos());
            for (LivingEntity entity : this.getEntities(pLevel, pPos, pState)) {
                if (!entity.m_6072_()) continue;
                entity.changeDimension(destination, (ITeleporter)teleporter);
                if (this.spendStormlight(pLevel, pOathgate)) continue;
                break;
            }
            pOathgate.sendUpdate();
            pLevel.m_7696_(pPos, pState.m_60734_(), 1, 0);
            return true;
        }
        return false;
    }

    protected boolean teleport(BlockState pState, Level pLevel, BlockPos pPos, OathgateBlockEntity pOathgate) {
        if (pLevel.m_5776_() || !pOathgate.hasPair()) {
            return false;
        }
        BlockPos pairPos = pOathgate.getPair();
        BlockState pairState = pLevel.m_8055_(pairPos);
        if (!pairState.m_60713_((Block)StormwardBlocks.OATHGATE.get())) {
            return false;
        }
        Vec3 center = pPos.m_252807_();
        Vec3 pairCenter = pairPos.m_252807_();
        float yRot = ((Direction)pairState.m_61143_((Property)FACING)).m_122435_() - ((Direction)pState.m_61143_((Property)FACING)).m_122435_();
        for (LivingEntity pEntity : this.getEntities(pLevel, pPos, pState)) {
            Vec3 destination = pairCenter.m_82549_(pEntity.m_20182_().m_82546_(center).m_82524_(-yRot * ((float)Math.PI / 180)));
            pEntity.m_6021_(destination.f_82479_, destination.f_82480_, destination.f_82481_);
            if (pEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)pEntity;
                int rot = Mth.m_14143_((float)((player.m_146908_() + yRot) * 256.0f / 360.0f));
                if (Math.abs((float)rot - pEntity.m_146908_()) >= 1.0f) {
                    PacketHandler.sendToPlayer(new ClientboundRotatePlayerPacket((byte)rot), player);
                }
            } else {
                pEntity.m_146922_(pEntity.m_146908_() + yRot);
            }
            if (this.spendStormlight(pLevel, pOathgate)) continue;
            break;
        }
        pOathgate.sendUpdate();
        pLevel.m_7696_(pPos, pState.m_60734_(), 1, 0);
        return true;
    }

    protected boolean spendStormlight(Level pLevel, OathgateBlockEntity pOathgate) {
        if (pLevel.m_46469_().m_46207_(StormwardGameRules.RULE_BLOCKS_CONSUME_STORMLIGHT)) {
            return pOathgate.getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> {
                stormlightStorage.extractStormlight(2, false);
                return !stormlightStorage.isDun();
            }).orElse(false);
        }
        return true;
    }

    @Override
    public void m_6807_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pMovedByPiston) {
        if (pLevel.m_46472_() == StormwardDimensions.SHADESMAR_DIMENSION) {
            this.addSpren(pLevel, pPos, pState, true);
            this.addSpren(pLevel, pPos, pState, false);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    @Override
    public boolean m_8133_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, int pId, int pParam) {
        if (super.m_8133_(pState, pLevel, pPos, pId, pParam)) {
            return true;
        }
        if (pId == 1) {
            this.playTeleportEffects(pState, pLevel, pPos);
            return true;
        }
        return false;
    }

    public static boolean hasDestination(Level pLevel) {
        return pLevel.m_46472_() == Level.f_46428_ || pLevel.m_46472_() == StormwardDimensions.SHADESMAR_DIMENSION;
    }

    public static ServerLevel getDestination(ServerLevel pServerLevel) {
        MinecraftServer server = pServerLevel.m_7654_();
        ResourceKey<Level> key = pServerLevel.m_46472_() == StormwardDimensions.SHADESMAR_DIMENSION ? Level.f_46428_ : StormwardDimensions.SHADESMAR_DIMENSION;
        return server.m_129880_(key);
    }

    public static boolean canReplace(Level pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        return !state.m_60713_((Block)StormwardBlocks.OATHGATE.get()) && state.m_60800_((BlockGetter)pLevel, pPos) >= 0.0f;
    }

    public static BlockPos getPlatformCenter(BlockPos pPos, BlockState pState) {
        return pPos.m_7495_().m_5484_((Direction)pState.m_61143_((Property)FACING), 2);
    }

    protected List<LivingEntity> getEntities(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockPos center = OathgateBlock.getPlatformCenter(pPos, pState).m_7494_();
        return pLevel.m_6443_(LivingEntity.class, new AABB(center).m_82400_(6.0), entity -> entity.m_20238_(center.m_252807_()) < 36.0 && entity.m_20227_(1.0) >= (double)center.m_123342_());
    }

    private void addSpren(Level pLevel, BlockPos pPos, BlockState pState, boolean isLeft) {
        OathgateSpren spren = new OathgateSpren(pLevel, pPos, isLeft ? OathgateSprenVariant.WHITE : OathgateSprenVariant.BLACK);
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        spren.m_146884_(pPos.m_5484_(direction.m_122424_(), 4).m_6630_(3).m_5484_(direction.m_122427_(), isLeft ? -4 : 4).m_252807_());
        spren.m_146922_(direction.m_122435_());
        spren.setVariant(isLeft ? OathgateSprenVariant.BLACK : OathgateSprenVariant.WHITE);
        pLevel.m_7967_((Entity)spren);
    }

    private void playTeleportEffects(BlockState pState, Level pLevel, BlockPos pPos) {
        if (pLevel.m_5776_()) {
            pLevel.m_245747_(pPos, (SoundEvent)StormwardSoundEvents.OATHGATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            Vec3 center = OathgateBlock.getPlatformCenter(pPos, pState).m_7494_().m_252807_();
            for (int i = 0; i < 64; ++i) {
                double t = Math.PI * 2 * pLevel.f_46441_.m_188500_();
                double u = pLevel.f_46441_.m_188500_() + pLevel.f_46441_.m_188500_();
                double r = u > 1.0 ? 2.0 - u : u;
                Vec3 pos = center.m_82520_(6.0 * r * Math.cos(t), 0.0, 6.0 * r * Math.sin(t));
                pLevel.m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0));
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

