/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.pairedfabrial;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.stormlightstorage.StormlightTransferBlock;
import us.amon.stormward.blockentity.pairedfabrial.PairedBlockEntity;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.sound.StormwardSoundEvents;

public class PairedBlock<T extends PairedBlockEntity>
extends StormlightTransferBlock<T> {
    protected PairedBlock(int pMaxStormlight, RegistryObject<BlockEntityType<T>> pEntityType, BlockBehaviour.Properties pProperties) {
        super(pMaxStormlight, pEntityType, pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DUN, (Comparable)Boolean.valueOf(true)));
    }

    protected PairedBlock(ForgeConfigSpec.ConfigValue<Integer> pMaxStormlightConfigValue, RegistryObject<BlockEntityType<T>> pEntityType, BlockBehaviour.Properties pProperties) {
        super(pMaxStormlightConfigValue, pEntityType, pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DUN, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{DUN});
    }

    public void m_6807_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        if (!pMovedByPiston && !pOldState.m_60713_(pState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof PairedBlockEntity) {
            PairedBlockEntity pairedEntity = (PairedBlockEntity)blockEntity;
            pairedEntity.onPlace();
        }
    }

    @Override
    public void m_6810_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!pIsMoving && !pState.m_60713_(pNewState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof PairedBlockEntity) {
            PairedBlockEntity pairedEntity = (PairedBlockEntity)blockEntity;
            pairedEntity.onRemove();
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public boolean canPairWith(BlockState pState, BlockState pOtherState) {
        return pState.m_60713_(pOtherState.m_60734_());
    }

    public boolean m_8133_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            PairedBlock.playPairEffects(pLevel, pPos, pParam == 0);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        PairedBlockEntity pairedEntity;
        BlockEntity blockEntity;
        if (pHand == InteractionHand.MAIN_HAND && pPlayer.m_21120_(pHand).m_41619_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof PairedBlockEntity && (pairedEntity = (PairedBlockEntity)blockEntity).hasPair()) {
            PairedBlock.playPairEffects(pLevel, pPos, true);
            if (pLevel.m_46749_(pairedEntity.getPair())) {
                PairedBlock.playPairEffects(pLevel, pairedEntity.getPair(), true);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public static void playPairEffects(Level pLevel, BlockPos pPos, boolean pPaired) {
        if (pLevel.m_5776_()) {
            if (pPaired) {
                pLevel.m_245747_(pPos, (SoundEvent)StormwardSoundEvents.FABRIAL_PAIR.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            } else {
                pLevel.m_245747_(pPos, (SoundEvent)StormwardSoundEvents.FABRIAL_UNPAIR.get(), SoundSource.BLOCKS, 1.0f, 1.0f - pLevel.f_46441_.m_188501_() * 0.1f, false);
            }
            RandomSource random = pLevel.f_46441_;
            for (int i = 0; i < 12; ++i) {
                Vec3 particlePos = switch (random.m_188503_(3)) {
                    case 0 -> pPos.m_252807_().m_82520_(random.m_188499_() ? 0.5 : -0.5, random.m_188499_() ? 0.5 : -0.5, random.m_188500_() - 0.5);
                    case 1 -> pPos.m_252807_().m_82520_(random.m_188499_() ? 0.5 : -0.5, random.m_188500_() - 0.5, random.m_188499_() ? 0.5 : -0.5);
                    default -> pPos.m_252807_().m_82520_(random.m_188500_() - 0.5, random.m_188499_() ? 0.5 : -0.5, random.m_188499_() ? 0.5 : -0.5);
                };
                pLevel.m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT.get(), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0));
            }
        }
    }
}

