/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.pairedfabrial;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;
import us.amon.stormward.block.pairedfabrial.PairedBlock;
import us.amon.stormward.block.pairedfabrial.PairedMovementStructureResolver;
import us.amon.stormward.blockentity.pairedfabrial.PairedMovementBlockEntity;
import us.amon.stormward.blockentity.pairedfabrial.PairedMovementMovingBlockEntity;

public class PairedMovementBlock<T extends PairedMovementBlockEntity>
extends PairedBlock<T> {
    private final boolean isSticky;

    public PairedMovementBlock(boolean pIsSticky, ForgeConfigSpec.ConfigValue<Integer> pMaxStormlightConfigValue, RegistryObject<BlockEntityType<T>> pEntityType, BlockBehaviour.Properties pProperties) {
        super(pMaxStormlightConfigValue, pEntityType, pProperties);
        this.isSticky = pIsSticky;
    }

    public boolean isStickyBlock(BlockState state) {
        return this.isSticky;
    }

    public boolean canStickTo(BlockState state, BlockState other) {
        if (other.m_60734_() == Blocks.f_50719_) {
            return false;
        }
        return super.canStickTo(state, other);
    }

    public boolean canMovePair(Level pLevel, BlockPos pPos, Direction pFacing, boolean pExtending) {
        return this.canMovePairHelper(pLevel, pPos, pFacing, pExtending, new HashSet<BlockPos>());
    }

    private boolean canMovePairHelper(Level pLevel, BlockPos pPos, Direction pFacing, boolean pExtending, Set<BlockPos> pVisited) {
        PairedMovementBlockEntity pairedEntity;
        if (pVisited.contains(pPos)) {
            return false;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof PairedMovementBlockEntity && (pairedEntity = (PairedMovementBlockEntity)blockEntity).hasPair()) {
            BlockPos pairPos = pairedEntity.getPair();
            pVisited.add(pPos);
            pVisited.add(pairPos);
            pFacing = this.getPairFacing(pFacing);
            PairedMovementStructureResolver resolver = new PairedMovementStructureResolver(pLevel, pairPos, pFacing, pExtending);
            if (!resolver.resolve()) {
                return false;
            }
            for (BlockPos pos : resolver.getToPush()) {
                if (pairPos.equals((Object)pos) || this.canMovePairHelper(pLevel, pos, pFacing, pExtending, pVisited)) continue;
                return false;
            }
        }
        return true;
    }

    public void onMoved(Level pLevel, BlockPos pPos, Direction pFacing, boolean pExtending) {
        PairedMovementBlockEntity pairedEntity;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof PairedMovementBlockEntity && (pairedEntity = (PairedMovementBlockEntity)blockEntity).hasPair()) {
            pFacing = this.getPairFacing(pFacing);
            Direction direction = pExtending ? pFacing : pFacing.m_122424_();
            BlockPos pairPos = pairedEntity.getPair();
            BlockEntity blockEntity2 = pLevel.m_7702_(pairPos);
            if (blockEntity2 instanceof PairedMovementBlockEntity) {
                PairedMovementBlockEntity otherEntity = (PairedMovementBlockEntity)blockEntity2;
                otherEntity.setPair(pPos.m_121945_(this.getPairFacing(direction)));
                otherEntity.applyMoveCost();
            }
            pairedEntity.setPair(pairPos.m_121945_(direction));
            pairedEntity.applyMoveCost();
            this.moveBlocks(pLevel, pairPos, pFacing, pExtending);
        }
    }

    protected Direction getPairFacing(Direction pFacing) {
        return pFacing;
    }

    private boolean moveBlocks(Level pLevel, BlockPos pPos, Direction pFacing, boolean pExtending) {
        PairedMovementBlock pairedBlock;
        Block block;
        PairedMovementStructureResolver resolver = new PairedMovementStructureResolver(pLevel, pPos, pFacing, pExtending);
        if (!resolver.resolve()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = resolver.getToPush();
        ArrayList list1 = Lists.newArrayList();
        for (BlockPos blockpos1 : list) {
            BlockState blockstate = pLevel.m_8055_(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        for (BlockPos pos : list) {
            if (pPos.equals((Object)pos) || !((block = ((BlockState)map.get(pos)).m_60734_()) instanceof PairedMovementBlock) || (pairedBlock = (PairedMovementBlock)block).canMovePair(pLevel, pos, pFacing, pExtending)) continue;
            return false;
        }
        for (BlockPos pos : list) {
            if (pPos.equals((Object)pos) || !((block = ((BlockState)map.get(pos)).m_60734_()) instanceof PairedMovementBlock)) continue;
            pairedBlock = (PairedMovementBlock)block;
            pairedBlock.onMoved(pLevel, pos, pFacing, pExtending);
        }
        List<BlockPos> list2 = resolver.getToDestroy();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = pExtending ? pFacing : pFacing.m_122424_();
        int i = 0;
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos2 = list2.get(j);
            BlockState blockState = pLevel.m_8055_(blockpos2);
            BlockEntity blockentity = blockState.m_155947_() ? pLevel.m_7702_(blockpos2) : null;
            PairedMovementBlock.m_49892_((BlockState)blockState, (LevelAccessor)pLevel, (BlockPos)blockpos2, (BlockEntity)blockentity);
            pLevel.m_7731_(blockpos2, Blocks.f_50016_.m_49966_(), 18);
            pLevel.m_220407_(GameEvent.f_157794_, blockpos2, GameEvent.Context.m_223722_((BlockState)blockState));
            if (!blockState.m_204336_(BlockTags.f_13076_)) {
                pLevel.m_142052_(blockpos2, blockState);
            }
            ablockstate[i++] = blockState;
        }
        for (int k = list.size() - 1; k >= 0; --k) {
            Object blockpos3 = list.get(k);
            BlockState blockState = pLevel.m_8055_((BlockPos)blockpos3);
            blockpos3 = blockpos3.m_121945_(direction);
            map.remove(blockpos3);
            BlockState blockstate8 = (BlockState)Blocks.f_50110_.m_49966_().m_61124_((Property)PistonBaseBlock.f_52588_, (Comparable)pFacing);
            pLevel.m_7731_((BlockPos)blockpos3, blockstate8, 68);
            BlockEntity blockEntity = pLevel.m_7702_(list.get(k));
            if (blockEntity instanceof PairedMovementBlockEntity) {
                PairedMovementBlockEntity pairedEntity = (PairedMovementBlockEntity)blockEntity;
                pLevel.m_151523_((BlockEntity)new PairedMovementMovingBlockEntity((BlockPos)blockpos3, blockstate8, (BlockState)list1.get(k), pFacing, pExtending, pairedEntity));
            } else {
                pLevel.m_151523_(MovingPistonBlock.m_155881_((BlockPos)blockpos3, (BlockState)blockstate8, (BlockState)((BlockState)list1.get(k)), (Direction)pFacing, (boolean)pExtending, (boolean)false));
            }
            ablockstate[i++] = blockState;
        }
        BlockState blockstate3 = Blocks.f_50016_.m_49966_();
        for (BlockPos blockPos : map.keySet()) {
            pLevel.m_7731_(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)entry.getValue();
            blockstate2.m_60758_((LevelAccessor)pLevel, blockpos5, 2);
            blockstate3.m_60701_((LevelAccessor)pLevel, blockpos5, 2);
            blockstate3.m_60758_((LevelAccessor)pLevel, blockpos5, 2);
        }
        i = 0;
        for (int l = list2.size() - 1; l >= 0; --l) {
            BlockState blockState = ablockstate[i++];
            BlockPos blockpos6 = list2.get(l);
            blockState.m_60758_((LevelAccessor)pLevel, blockpos6, 2);
            pLevel.m_46672_(blockpos6, blockState.m_60734_());
        }
        for (int i1 = list.size() - 1; i1 >= 0; --i1) {
            pLevel.m_46672_(list.get(i1), ablockstate[i++].m_60734_());
        }
        return true;
    }
}

