/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.stormlightstorage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.stormlightstorage.StormlightTransferBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.stormlightstorage.TransferenceStandEntity;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.sound.StormwardSoundEvents;

public class TransferenceStandBlock
extends StormlightTransferBlock<TransferenceStandEntity> {
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), (VoxelShape)Block.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0));
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HAS_ITEM = BooleanProperty.m_61465_((String)"has_item");
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public TransferenceStandBlock(BlockBehaviour.Properties pProperties) {
        super(0, StormwardBlockEntities.TRANSFERENCE_STAND, pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_ITEM, (Comparable)Boolean.FALSE)).m_61124_((Property)IS_TRANSFERRING, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, HAS_ITEM, IS_TRANSFERRING, LIT});
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof TransferenceStandEntity) {
            TransferenceStandEntity standEntity = (TransferenceStandEntity)blockEntity;
            if (!pLevel.m_5776_()) {
                if (pPlayer.m_21120_(pHand).m_150930_((Item)StormwardItems.TUNING_FORK.get())) {
                    return InteractionResult.PASS;
                }
                if (!((Boolean)pState.m_61143_((Property)HAS_ITEM)).booleanValue()) {
                    ItemStack stack = pPlayer.m_21120_(pHand).m_41620_(1);
                    if (!stack.m_41619_()) {
                        standEntity.setItem(stack);
                        pLevel.m_5594_(null, pPos, (SoundEvent)StormwardSoundEvents.TRANSFERENCE_STAND_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    standEntity.popOutItem();
                }
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }
}

