/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingDrownEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.damage.StormwardDamageSources;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.sound.StormwardSoundEvents;
import us.amon.stormward.tag.StormwardEntityTypeTags;
import us.amon.stormward.util.ILocalPlayer;

public class CognitiveBeadsBlock
extends FallingBlock
implements BucketPickup {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    protected static final VoxelShape UPPER_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final float FOG_COLOR_RED = 0.051f;
    private static final float FOG_COLOR_GREEN = 0.0627f;
    private static final float FOG_COLOR_BLUE = 0.1176f;
    private static final int DUST_COLOR = 3962801;

    public CognitiveBeadsBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{UP});
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        BlockState state = super.m_5573_(pContext);
        if (state != null) {
            return (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(pContext.m_43725_().m_8055_(pContext.m_8083_().m_7494_()).m_60713_((Block)StormwardBlocks.COGNITIVE_BEADS.get())));
        }
        return null;
    }

    public boolean m_6104_(@NotNull BlockState pState, BlockState pAdjacentState, @NotNull Direction pDirection) {
        return pAdjacentState.m_60713_((Block)StormwardBlocks.COGNITIVE_BEADS.get()) && (pDirection.m_122434_() == Direction.Axis.Y || pState.m_61143_((Property)UP) == pAdjacentState.m_61143_((Property)UP)) && (pDirection.m_122434_() == Direction.Axis.Y || pState.m_61143_((Property)UP) == pAdjacentState.m_61143_((Property)UP)) || super.m_6104_(pState, pAdjacentState, pDirection);
    }

    public void m_7892_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (!(pEntity instanceof LivingEntity) || pEntity.m_146900_().m_60713_((Block)this)) {
            RandomSource random;
            if (pEntity.m_6095_() != EntityType.f_20552_) {
                pEntity.m_7601_(pState, new Vec3((double)0.9f, 1.5, (double)0.9f));
            }
            if (pLevel.f_46443_ && (random = pLevel.m_213780_()).m_188503_(3) == 0) {
                pLevel.m_7106_((ParticleOptions)StormwardParticles.COGNITIVE_BEAD.get(), pEntity.m_20208_(0.75), (double)(pPos.m_123342_() + 1), pEntity.m_20262_(0.75), (double)(Mth.m_216283_((RandomSource)random, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.m_216283_((RandomSource)random, (float)-1.0f, (float)1.0f) * 0.083333336f));
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)UP) != false ? super.m_5940_(pState, pLevel, pPos, pContext) : UPPER_SHAPE;
    }

    public VoxelShape m_5939_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        EntityCollisionContext entitycollisioncontext;
        Entity entity;
        if (pContext instanceof EntityCollisionContext && (entity = (entitycollisioncontext = (EntityCollisionContext)pContext).m_193113_()) != null) {
            if (entity.m_6095_() == EntityType.f_20552_) {
                return super.m_5939_(pState, pLevel, pPos, pContext);
            }
            if (entity instanceof FallingBlockEntity) {
                return Shapes.m_83144_();
            }
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
        }
        return Shapes.m_83040_();
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Shapes.m_83040_();
    }

    @NotNull
    public VoxelShape m_7952_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return Shapes.m_83040_();
    }

    public int m_6248_(@NotNull BlockState pState, @NotNull BlockGetter pReader, @NotNull BlockPos pPos) {
        return 3962801;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        BlockState state = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (pFacing == Direction.UP) {
            return (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(pFacingState.m_60713_((Block)StormwardBlocks.COGNITIVE_BEADS.get())));
        }
        return state;
    }

    public void m_48792_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull BlockState pReplaceableState, @NotNull FallingBlockEntity pFallingBlock) {
        pLevel.m_7696_(pPos, pState.m_60734_(), 0, 0);
    }

    public boolean m_8133_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, int pId, int pParam) {
        if (pId == 0) {
            if (pLevel.f_46443_) {
                RandomSource random = pLevel.m_213780_();
                for (int i = 0; i < 8; ++i) {
                    double x = Mth.m_216283_((RandomSource)random, (float)-0.5f, (float)0.5f);
                    double z = Mth.m_216283_((RandomSource)random, (float)-0.5f, (float)0.5f);
                    pLevel.m_7106_((ParticleOptions)StormwardParticles.COGNITIVE_BEAD.get(), (double)pPos.m_123341_() + x + 0.5, (double)pPos.m_123342_(), (double)pPos.m_123343_() + z + 0.5, x * (double)0.15f, (double)0.15f, z * (double)0.15f);
                }
            }
            return true;
        }
        return false;
    }

    public static void onLivingBreathe(LivingBreatheEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_8055_(BlockPos.m_274446_((Position)entity.m_146892_())).m_60713_((Block)StormwardBlocks.COGNITIVE_BEADS.get()) && !entity.m_6095_().m_204039_(StormwardEntityTypeTags.BEAD_IMMUNE)) {
            event.setCanBreathe(false);
        }
    }

    public static void onLivingDrown(LivingDrownEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_8055_(BlockPos.m_274446_((Position)entity.m_146892_())).m_60713_((Block)StormwardBlocks.COGNITIVE_BEADS.get())) {
            event.setDrowning(false);
            entity.m_20301_(0);
            if (event.getDamageAmount() > 0.0f) {
                entity.m_6469_(StormwardDamageSources.cognitiveBeads(entity.m_9236_()), event.getDamageAmount());
            }
        }
    }

    public static void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        ILocalPlayer localPlayer;
        LocalPlayer localPlayer2 = Minecraft.m_91087_().f_91074_;
        if (localPlayer2 instanceof ILocalPlayer && (localPlayer = (ILocalPlayer)localPlayer2).stormward$isInCognitiveBeads()) {
            event.setRed(0.051f);
            event.setGreen(0.0627f);
            event.setBlue(0.1176f);
        }
    }

    public static void onRenderFog(ViewportEvent.RenderFog event) {
        ILocalPlayer localPlayer;
        LocalPlayer localPlayer2 = Minecraft.m_91087_().f_91074_;
        if (localPlayer2 instanceof ILocalPlayer && (localPlayer = (ILocalPlayer)localPlayer2).stormward$isInCognitiveBeads()) {
            event.setNearPlaneDistance(0.0f);
            event.setFarPlaneDistance(2.0f);
            event.setCanceled(true);
        }
    }

    public static void onComputeFovModifier(ComputeFovModifierEvent event) {
        ILocalPlayer localPlayer;
        Player player = event.getPlayer();
        if (player instanceof ILocalPlayer && (localPlayer = (ILocalPlayer)player).stormward$isInCognitiveBeads()) {
            float f1 = 1.0f - (float)event.getPlayer().m_20146_() / (float)event.getPlayer().m_6062_();
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewFovModifier(event.getNewFovModifier() * (1.0f - f1 * 0.15f));
        }
    }

    @NotNull
    public ItemStack m_142598_(@Nullable Player pPlayer, LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 11);
        if (!pLevel.m_5776_()) {
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
        }
        return new ItemStack((ItemLike)StormwardItems.COGNITIVE_BEADS_BUCKET.get());
    }

    @NotNull
    public Optional<SoundEvent> m_142298_() {
        return Optional.of((SoundEvent)StormwardSoundEvents.BUCKET_FILL_COGNITIVE_BEADS.get());
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }
}

