/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.block.pairedfabrial.OathgateBlock;
import us.amon.stormward.blockentity.PerpendicularityBlockEntity;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.worldgen.portal.ShadesmarTeleporter;

public class PerpendicularityBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public PerpendicularityBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        BlockState result = super.m_5573_(pContext);
        if (result != null) {
            result = (BlockState)result.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return result;
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return pState;
    }

    @NotNull
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_5946_(@NotNull BlockState pState, @NotNull Fluid pFluid) {
        return false;
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return ItemStack.f_41583_;
    }

    public void m_7892_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof PerpendicularityBlockEntity) {
                PerpendicularityBlockEntity perpendicularityEntity = (PerpendicularityBlockEntity)blockEntity;
                if (OathgateBlock.hasDestination((Level)serverLevel) && pEntity.m_6072_() && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)pEntity.m_20191_().m_82386_((double)(-pPos.m_123341_()), (double)(-pPos.m_123342_()), (double)(-pPos.m_123343_()))), (VoxelShape)pState.m_60808_((BlockGetter)pLevel, pPos), (BooleanOp)BooleanOp.f_82689_)) {
                    if (pEntity.m_287157_() <= 0) {
                        if (!perpendicularityEntity.tryCreateMirror(serverLevel)) {
                            return;
                        }
                        pEntity.changeDimension(OathgateBlock.getDestination(serverLevel), (ITeleporter)new ShadesmarTeleporter(pPos, perpendicularityEntity.getMirrorPos()));
                    }
                    pEntity.m_20091_();
                }
            }
        }
    }

    public void m_6810_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pNewState, boolean pMovedByPiston) {
        PerpendicularityBlockEntity perpendicularityEntity;
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (pLevel instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)pLevel).m_7702_(pPos)) instanceof PerpendicularityBlockEntity && (perpendicularityEntity = (PerpendicularityBlockEntity)blockEntity).hasMirror()) {
            OathgateBlock.getDestination(serverLevel).m_7471_(perpendicularityEntity.getMirrorPos(), false);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public void m_214162_(@NotNull BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
        double d1 = (double)pPos.m_123342_() + 0.6;
        double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
        pLevel.m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT.get(), d0, d1, d2, 0.0, 0.05, 0.0);
    }

    public boolean m_6104_(@NotNull BlockState pState, BlockState pAdjacentBlockState, @NotNull Direction pSide) {
        if (pAdjacentBlockState.m_60713_((Block)this) && pSide.m_122434_() != Direction.Axis.Y) {
            return true;
        }
        return super.m_6104_(pState, pAdjacentBlockState, pSide);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)StormwardBlockEntities.PERPENDICULARITY.get()).m_155264_(pPos, pState);
    }
}

