/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen.plant;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.block.worldgen.plant.RosharanPlantBlock;
import us.amon.stormward.block.worldgen.plant.StormwardPlantTypes;

public class LavisPolypBlock
extends RosharanPlantBlock
implements IPlantable,
BonemealableBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    protected static final VoxelShape[] AABB = new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)};

    public LavisPolypBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PLANT_REACTION, (Comparable)((Object)PlantReaction.EXTENDED))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PLANT_REACTION, AGE});
    }

    @Override
    public void m_213898_(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        super.m_213898_(pState, pLevel, pPos, pRandom);
        int i = (Integer)pState.m_61143_((Property)AGE);
        if (i < 3 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pLevel.f_46441_.m_188503_(12) == 0 ? 1 : 0) != 0)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return AABB[(Integer)pState.m_61143_((Property)AGE)];
    }

    @Override
    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        return !pState.m_60710_((LevelReader)pLevel, pPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public boolean m_7898_(@NotNull BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        return pLevel.m_8055_(blockpos).canSustainPlant((BlockGetter)pLevel, blockpos, Direction.UP, (IPlantable)this);
    }

    public boolean m_7370_(@NotNull LevelReader pLevel, @NotNull BlockPos pPos, BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, BlockState pState) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)AGE) + 1)), 2);
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return StormwardPlantTypes.ROSHARAN;
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return this.m_49966_();
    }
}

