/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.block.worldgen.plant;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.worldgen.plant.PlantReaction;
import us.amon.stormward.block.worldgen.plant.RosharanTallGrassBlock;
import us.amon.stormward.tag.StormwardBlockTags;
import us.amon.stormward.weather.Highstorm;

public class StumpweightLeavesBlock
extends RosharanTallGrassBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)3.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0)));

    public StumpweightLeavesBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PLANT_REACTION, (Comparable)((Object)PlantReaction.EXTENDED))).m_61124_((Property)FACING, (Comparable)Direction.WEST));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7898_(BlockState pState, @NotNull LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_());
        return this.m_6266_(pLevel.m_8055_(blockpos), (BlockGetter)pLevel, blockpos);
    }

    @Override
    protected boolean m_6266_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return pState.m_204336_(StormwardBlockTags.STUMPWEIGHT_LOGS);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = this.m_49966_();
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        for (Direction direction : pContext.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction)).m_60710_((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return AABBS.get(pState.m_61143_((Property)FACING));
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Override
    public void randomTickPlant(Level pLevel, BlockPos pPos, BlockState pState) {
        super.randomTickPlant(pLevel, pPos, pState);
        while (pLevel.m_8055_(pPos.m_7494_()).m_60713_((Block)StormwardBlocks.STUMPWEIGHT_LEAVES.get())) {
            pPos = pPos.m_7494_();
        }
        if (Highstorm.isBlockExposedToHighstorm(pLevel, pPos)) {
            pState = pLevel.m_8055_(pPos);
            while (pState.m_60713_((Block)StormwardBlocks.STUMPWEIGHT_LEAVES.get())) {
                this.retract(pLevel, pPos, pState);
                pPos = pPos.m_7495_();
                pState = pLevel.m_8055_(pPos);
            }
        }
    }

    @Override
    public void highstormTick(Level pLevel, BlockPos pPos, BlockState pState) {
        while (pState.m_60713_((Block)StormwardBlocks.STUMPWEIGHT_LEAVES.get())) {
            this.retract(pLevel, pPos, pState);
            pPos = pPos.m_7495_();
            pState = pLevel.m_8055_(pPos);
        }
    }
}

