/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity;

import java.util.HashSet;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.pairedfabrial.OathgateBlock;
import us.amon.stormward.block.worldgen.PerpendicularityBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.worldgen.dimension.StormwardDimensions;

public class PerpendicularityBlockEntity
extends BlockEntity {
    private BlockPos mirrorPos;

    public PerpendicularityBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.PERPENDICULARITY.get(), pPos, pBlockState);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.mirrorPos = pTag.m_128441_("Mirror") ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("Mirror")) : null;
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.mirrorPos != null) {
            pTag.m_128365_("Mirror", (Tag)NbtUtils.m_129224_((BlockPos)this.mirrorPos));
        }
    }

    public boolean hasMirror() {
        return this.mirrorPos != null;
    }

    public BlockPos getMirrorPos() {
        return this.mirrorPos;
    }

    public void setMirrorPos(BlockPos pMirrorPos) {
        this.mirrorPos = pMirrorPos;
        this.m_6596_();
    }

    public PerpendicularityBlockEntity getMirror() {
        ServerLevel serverLevel;
        Level level;
        if (this.hasMirror() && (level = this.m_58904_()) instanceof ServerLevel && OathgateBlock.hasDestination((Level)(serverLevel = (ServerLevel)level))) {
            return (PerpendicularityBlockEntity)OathgateBlock.getDestination(serverLevel).m_7702_(this.mirrorPos);
        }
        return null;
    }

    public boolean tryCreateMirror(ServerLevel pLevel) {
        BlockEntity relative;
        if (!OathgateBlock.hasDestination((Level)pLevel)) {
            return false;
        }
        ServerLevel destination = OathgateBlock.getDestination(pLevel);
        if (this.hasMirror() && this.getMirror() != null) {
            return true;
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(this.m_58899_());
        HashSet<Object> seen = new HashSet<Object>();
        seen.add(this.m_58899_());
        while (!stack.isEmpty()) {
            BlockPos pos = (BlockPos)stack.pop();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                relative = pos.m_121945_(direction);
                if (seen.contains(relative) || !pLevel.m_8055_((BlockPos)relative).m_60713_((Block)StormwardBlocks.PERPENDICULARITY.get())) continue;
                stack.push(relative);
                seen.add(relative);
            }
        }
        for (BlockPos blockPos : seen) {
            BlockState state;
            BlockPos mirrorPos;
            PerpendicularityBlockEntity perpendicularity;
            relative = pLevel.m_7702_(blockPos);
            if (!(relative instanceof PerpendicularityBlockEntity) || (perpendicularity = (PerpendicularityBlockEntity)relative).hasMirror() || !destination.m_7731_(mirrorPos = StormwardDimensions.convert(blockPos, (ResourceKey<Level>)destination.m_46472_()), state = (BlockState)perpendicularity.m_58900_().m_61124_((Property)PerpendicularityBlock.WATERLOGGED, (Comparable)Boolean.valueOf(destination.m_6425_(mirrorPos).m_76152_() == Fluids.f_76193_)), 3)) continue;
            perpendicularity.setMirrorPos(mirrorPos);
            BlockEntity blockEntity = destination.m_7702_(mirrorPos);
            if (!(blockEntity instanceof PerpendicularityBlockEntity)) continue;
            PerpendicularityBlockEntity mirror = (PerpendicularityBlockEntity)blockEntity;
            mirror.setMirrorPos(blockPos);
        }
        return this.hasMirror();
    }
}

