/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.ascender;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.ascender.AscenderChainBlock;
import us.amon.stormward.block.ascender.AscenderCounterweightBlock;
import us.amon.stormward.block.ascender.MovingAscenderBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.ascender.AscenderEntity;
import us.amon.stormward.blockentity.ascender.MovingAscenderEntity;
import us.amon.stormward.sound.StormwardSoundEvents;

public class AscenderWinchEntity
extends AscenderEntity {
    public static final float GRAVITY = 0.08f;
    public static final float MAX_ACCEL = 2.0f;
    public static final float WIND_RATE = 0.05f;
    private final List<MovingAscenderEntity> entities = new ArrayList<MovingAscenderEntity>();
    private float length;
    private float acceleration;
    private boolean falling;
    private boolean winding;
    private long lastWindTick;
    private long lastFallTick;
    private int tick;

    public AscenderWinchEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.ASCENDER_WINCH.get(), pPos, pBlockState);
    }

    @Override
    protected AscenderWinchEntity getWinchEntity() {
        return this;
    }

    @Override
    protected int getPosition() {
        return 0;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, AscenderWinchEntity pBlockEntity) {
        pBlockEntity.tickWind(pLevel);
        pBlockEntity.tickFall(pLevel);
    }

    public void tickWind(Level pLevel) {
        if (this.winding) {
            ++this.tick;
            if (this.length <= (float)(this.entities.size() - 1)) {
                this.removeEntity(pLevel, this.entities.remove(this.entities.size() - 1));
            }
            if (pLevel.m_46467_() - this.lastWindTick > 4L || this.length <= 0.0f) {
                this.stopWinding();
                return;
            }
            this.length -= 0.05f;
            if (this.tick % 10 == 1) {
                pLevel.m_245747_(this.m_58899_(), (SoundEvent)StormwardSoundEvents.ASCENDER_WIND.get(), SoundSource.BLOCKS, 1.0f, 1.0f - pLevel.f_46441_.m_188501_() * 0.1f, false);
            }
        }
    }

    public void tickFall(Level pLevel) {
        if (pLevel.m_46467_() <= this.lastFallTick) {
            return;
        }
        this.lastFallTick = pLevel.m_46467_();
        if (this.falling) {
            ++this.tick;
            this.acceleration = Math.min(this.acceleration + 0.08f, 2.0f);
            this.length += this.acceleration;
            while (this.length > (float)this.entities.size()) {
                BlockState state;
                BlockPos pos = this.m_58899_().m_6625_(this.entities.size() + 1);
                if (this.canMoveThroughBlock(pLevel, pos, state = pLevel.m_8055_(pos)) || state.m_60713_((Block)StormwardBlocks.MOVING_ASCENDER.get())) {
                    this.addEntityAtPos(pLevel, this.entities.size() + 1);
                    continue;
                }
                this.stopFalling();
                pLevel.m_245747_(pos, (SoundEvent)StormwardSoundEvents.ASCENDER_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f - pLevel.f_46441_.m_188501_() * 0.1f, false);
                break;
            }
            if (this.falling && this.tick % 10 == 1) {
                pLevel.m_245747_(this.m_58899_(), (SoundEvent)StormwardSoundEvents.ASCENDER_FALL.get(), SoundSource.BLOCKS, 1.0f, 1.0f - pLevel.f_46441_.m_188501_() * 0.1f, false);
            }
        }
    }

    protected boolean canMoveThroughBlock(Level pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.m_46739_(pPos) && pState.m_247087_();
    }

    private void addEntityAtPos(Level pLevel, int pPosition) {
        BlockEntity blockEntity;
        BlockPos pos = this.m_58899_().m_6625_(pPosition);
        if (pLevel.m_8055_(pos).m_60713_((Block)StormwardBlocks.MOVING_ASCENDER.get()) && (blockEntity = pLevel.m_7702_(pos)) instanceof MovingAscenderEntity) {
            MovingAscenderEntity movingEntity = (MovingAscenderEntity)blockEntity;
            if (!this.entities.contains((Object)movingEntity)) {
                this.entities.add(movingEntity);
            }
            return;
        }
        BlockState state = ((MovingAscenderBlock)((Object)StormwardBlocks.MOVING_ASCENDER.get())).m_49966_();
        pLevel.m_7731_(pos, state, 8);
        MovingAscenderEntity movingEntity = new MovingAscenderEntity(pos, state, this, pPosition);
        pLevel.m_151523_((BlockEntity)movingEntity);
        this.entities.add(movingEntity);
        pLevel.m_7260_(pos, state, state, 8);
    }

    private void removeEntity(Level pLevel, MovingAscenderEntity pEntity) {
        BlockPos pos = pEntity.m_58899_();
        pLevel.m_46747_(pos);
        BlockState state = Blocks.f_50016_.m_49966_();
        pLevel.m_7731_(pos, state, 8);
        pLevel.m_7260_(pos, state, state, 8);
    }

    public boolean isFalling() {
        return this.falling;
    }

    public boolean canFall() {
        BlockPos pos = this.m_58899_().m_7495_();
        while (this.isMovableBlock(this.f_58857_.m_8055_(pos))) {
            pos = pos.m_7495_();
        }
        return this.canMoveThroughBlock(this.f_58857_, pos, this.f_58857_.m_8055_(pos));
    }

    public void startFalling() {
        if (this.falling) {
            return;
        }
        this.falling = true;
        if (this.winding) {
            this.stopWinding();
        }
        this.convertMovableBlocksToEntities();
    }

    public void stopFalling() {
        if (!this.falling) {
            return;
        }
        this.falling = false;
        this.convertEntitiesToBlocks();
    }

    public boolean isWinding() {
        return this.winding;
    }

    public boolean canWind() {
        return this.isMovableBlock(this.f_58857_.m_8055_(this.m_58899_().m_7495_()));
    }

    public void wind() {
        this.lastWindTick = this.f_58857_.m_46467_();
        if (this.falling || this.winding || !this.canWind()) {
            return;
        }
        this.winding = true;
        this.convertMovableBlocksToEntities();
    }

    public void stopWinding() {
        if (!this.winding) {
            return;
        }
        this.winding = false;
        this.convertEntitiesToBlocks();
        if (this.length <= 0.0f) {
            this.f_58857_.m_245747_(this.m_58899_(), (SoundEvent)StormwardSoundEvents.ASCENDER_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f - this.f_58857_.f_46441_.m_188501_() * 0.1f, false);
        }
    }

    public boolean isMoving() {
        return this.isFalling() || this.isWinding();
    }

    private void convertMovableBlocksToEntities() {
        int position = 1;
        while (this.isMovableBlock(this.f_58857_.m_8055_(this.m_58899_().m_6625_(position)))) {
            this.addEntityAtPos(this.f_58857_, position);
            ++position;
        }
        this.length = this.entities.size();
        this.acceleration = 0.0f;
        this.tick = 0;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    private void convertEntitiesToBlocks() {
        this.length = this.entities.size();
        this.acceleration = 0.0f;
        this.tick = 0;
        if (!this.f_58857_.f_46443_) {
            for (int i = 0; i < this.entities.size(); ++i) {
                MovingAscenderEntity entity = this.entities.get(i);
                BlockState state = i >= this.entities.size() - 1 ? this.getCounterweightState() : this.getChainState();
                this.f_58857_.m_7731_(entity.m_58899_(), state, 3);
                this.f_58857_.m_7260_(entity.m_58899_(), state, state, 3);
                this.f_58857_.m_46747_(entity.m_58899_());
            }
        }
        this.entities.clear();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_245747_(this.m_58899_(), (SoundEvent)StormwardSoundEvents.ASCENDER_STOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f - this.f_58857_.f_46441_.m_188501_() * 0.1f, false);
    }

    protected boolean isMovableBlock(BlockState pState) {
        return pState.m_60713_((Block)StormwardBlocks.ASCENDER_CHAIN.get()) || pState.m_60713_((Block)StormwardBlocks.ASCENDER_COUNTERWEIGHT.get()) || pState.m_60713_((Block)StormwardBlocks.MOVING_ASCENDER.get());
    }

    public BlockState getChainState() {
        return ((AscenderChainBlock)StormwardBlocks.ASCENDER_CHAIN.get()).m_49966_();
    }

    public BlockState getCounterweightState() {
        return ((AscenderCounterweightBlock)StormwardBlocks.ASCENDER_COUNTERWEIGHT.get()).m_49966_();
    }

    public float getLength() {
        return this.length;
    }

    public float getLength(float pPartialTick) {
        if (this.winding) {
            return Mth.m_14179_((float)pPartialTick, (float)(this.length + 0.05f), (float)this.length);
        }
        if (this.falling) {
            return Mth.m_14179_((float)pPartialTick, (float)(this.length - this.acceleration), (float)this.length);
        }
        return this.length;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("Falling", this.isFalling());
        nbt.m_128350_("Length", this.getLength());
        nbt.m_128350_("Acceleration", this.getAcceleration());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag.m_128471_("Falling")) {
            if (!this.falling) {
                this.startFalling();
            }
        } else if (this.falling) {
            this.stopFalling();
        }
        this.length = tag.m_128457_("Length");
        this.acceleration = tag.m_128457_("Acceleration");
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128350_("Length", this.length);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.length = pTag.m_128457_("Length");
    }

    public void onChunkUnloaded() {
        this.stopMoving();
        super.onChunkUnloaded();
    }

    public void stopMoving() {
        if (this.winding) {
            this.stopWinding();
        }
        if (this.falling) {
            this.stopFalling();
        }
    }
}

