/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.pairedfabrial;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.pairedfabrial.PairedBlock;
import us.amon.stormward.blockentity.stormlightstorage.StormlightTransferBlockEntity;

public class PairedBlockEntity
extends StormlightTransferBlockEntity {
    private static final int PAIR_RANGE = 16;
    private BlockPos pairPos;

    public PairedBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void onPlace() {
        this.findAndConnectToPair();
    }

    public boolean findAndConnectToPair() {
        if (!this.hasPair() && this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            BlockPos pos = this.m_58899_();
            BlockState blockState = this.m_58900_();
            BlockPos.m_121930_((BlockPos)pos, (int)16, (int)16, otherPos -> PairedBlockEntity.isValidPair(this.m_58904_(), pos, blockState, otherPos, this.m_58904_().m_8055_(otherPos))).ifPresent(pairPos -> this.connectToPair(pos, blockState, (BlockPos)pairPos, this.m_58904_().m_8055_(pairPos)));
        }
        return this.hasPair();
    }

    protected static boolean isValidPair(Level pLevel, BlockPos pPos, BlockState pState, BlockPos pOtherPos, BlockState pOtherState) {
        PairedBlock pairedBlock;
        PairedBlockEntity pairedEntity;
        BlockEntity blockEntity;
        return !pPos.equals((Object)pOtherPos) && (blockEntity = pLevel.m_7702_(pOtherPos)) instanceof PairedBlockEntity && !(pairedEntity = (PairedBlockEntity)blockEntity).hasPair() && (blockEntity = pState.m_60734_()) instanceof PairedBlock && (pairedBlock = (PairedBlock)blockEntity).canPairWith(pState, pOtherState);
    }

    protected void connectToPair(BlockPos pPos, BlockState pState, BlockPos pPairPos, BlockState pPairState) {
        if (this.m_58904_() != null) {
            this.setPair(pPairPos);
            this.m_58904_().m_7696_(pPos, pState.m_60734_(), 0, 0);
            BlockEntity blockEntity = this.m_58904_().m_7702_(pPairPos);
            if (blockEntity instanceof PairedBlockEntity) {
                PairedBlockEntity pairedEntity = (PairedBlockEntity)blockEntity;
                pairedEntity.setPair(pPos);
                if (this.m_58904_().m_46749_(pPairPos)) {
                    this.m_58904_().m_7696_(pPairPos, pPairState.m_60734_(), 0, 0);
                }
            }
        }
    }

    public void onRemove() {
        BlockEntity blockEntity;
        if (this.m_58904_() != null && !this.m_58904_().m_5776_() && this.pairPos != null && (blockEntity = this.m_58904_().m_7702_(this.pairPos)) instanceof PairedBlockEntity) {
            PairedBlockEntity pairedEntity = (PairedBlockEntity)blockEntity;
            pairedEntity.setPair(null);
            if (!pairedEntity.findAndConnectToPair() && this.m_58904_().m_46749_(this.pairPos)) {
                this.m_58904_().m_7696_(this.pairPos, this.m_58904_().m_8055_(this.pairPos).m_60734_(), 0, 1);
            }
        }
    }

    public boolean hasPair() {
        return this.pairPos != null;
    }

    public void setPair(BlockPos pPairPos) {
        this.pairPos = pPairPos;
        this.sendUpdate();
    }

    public BlockPos getPair() {
        return this.pairPos;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.pairPos = pTag.m_128441_("Pair") ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("Pair")) : null;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.pairPos != null) {
            pTag.m_128365_("Pair", (Tag)NbtUtils.m_129224_((BlockPos)this.pairPos));
        }
    }
}

