/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.pairedfabrial;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.pairedfabrial.PairedMovementBlockEntity;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.capability.stormlightstorage.StormlightStorage;

public class PairedMovementMovingBlockEntity
extends PistonMovingBlockEntity {
    private final StormlightStorage storage;
    private final LazyOptional<IStormlightStorage> optional;
    private BlockPos pairPos;

    public PairedMovementMovingBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
        this.storage = new StormlightStorage(0, 0);
        this.optional = LazyOptional.of(() -> this.storage);
    }

    public PairedMovementMovingBlockEntity(BlockPos pPos, BlockState pBlockState, BlockState pMovedState, Direction pDirection, boolean pExtending, PairedMovementBlockEntity pOldEntity) {
        super(pPos, pBlockState, pMovedState, pDirection, pExtending, false);
        this.storage = pOldEntity.getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> new StormlightStorage(stormlightStorage.getMaxStormlight())).orElse(new StormlightStorage(0, 0));
        this.storage.copy((ICapabilityProvider)pOldEntity);
        this.optional = LazyOptional.of(() -> this.storage);
        this.pairPos = pOldEntity.getPair();
    }

    @NotNull
    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)StormwardBlockEntities.PAIRED_MOVING_BLOCK.get();
    }

    public boolean hasPair() {
        return this.pairPos != null;
    }

    public void setPair(BlockPos pPairPos) {
        this.pairPos = pPairPos;
        this.m_6596_();
    }

    public BlockPos getPair() {
        return this.pairPos;
    }

    public static void tick(Level pLevel, @NotNull BlockPos pPos, BlockState pState, PairedMovementMovingBlockEntity pBlockEntity) {
        PistonMovingBlockEntity.m_155915_((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (PistonMovingBlockEntity)pBlockEntity);
        pBlockEntity.copyPairedMovementData();
    }

    public void m_60401_() {
        super.m_60401_();
        this.copyPairedMovementData();
    }

    protected void copyPairedMovementData() {
        BlockEntity blockEntity;
        if (this.m_58901_() && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.m_58899_())) instanceof PairedMovementBlockEntity) {
            PairedMovementBlockEntity pairedEntity = (PairedMovementBlockEntity)blockEntity;
            this.reviveCaps();
            pairedEntity.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> stormlightStorage.copy((ICapabilityProvider)this));
            this.invalidateCaps();
            this.optional.invalidate();
            pairedEntity.setPair(this.getPair());
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        return StormwardCapabilities.STORMLIGHT.orEmpty(cap, this.optional);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.storage.deserializeNBT(pTag.m_128469_("Stormlight"));
        this.pairPos = pTag.m_128441_("Pair") ? NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("Pair")) : null;
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Stormlight", (Tag)this.storage.serializeNBT());
        if (this.pairPos != null) {
            pTag.m_128365_("Pair", (Tag)NbtUtils.m_129224_((BlockPos)this.pairPos));
        }
    }
}

