/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.stormlightstorage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.stormlightstorage.StormlightTransferBlockEntity;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.sound.StormwardSoundEvents;

public class CultivatorEntity
extends StormlightTransferBlockEntity {
    private static final int PULSE_INTERVAL = 80;
    private static final int RANGE = 4;
    private static final int PARTICLE_COUNT = 30;
    private static final int BLOCKS_PER_COST = 3;

    public CultivatorEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.CULTIVATOR.get(), pPos, pBlockState);
    }

    @Override
    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        super.tick(pLevel, pPos, pState);
        int stormlight = StormlightStorageHelper.getStormlight((ICapabilityProvider)this);
        if (pLevel.m_46467_() % 80L == 0L && stormlight > 0) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                int cost = 0;
                int blocksUntilPayment = 0;
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-4, -1, -4), (BlockPos)pPos.m_7918_(4, 0, 4))) {
                    BonemealableBlock bonemealableBlock;
                    BlockState state;
                    Block block;
                    if (!(pPos.m_123331_((Vec3i)pos) <= 20.25) || !((block = (state = pLevel.m_8055_(pos)).m_60734_()) instanceof BonemealableBlock) || !(bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)pLevel, pos, state) || !bonemealableBlock.m_214167_(pLevel, pLevel.f_46441_, pos, state)) continue;
                    bonemealableBlock.m_214148_(serverLevel, pLevel.f_46441_, pos, state);
                    if (blocksUntilPayment <= 0) {
                        blocksUntilPayment = 3;
                        if (++cost >= stormlight) break;
                    }
                    --blocksUntilPayment;
                }
                if (cost > 0) {
                    int finalCost = cost;
                    this.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> stormlightStorage.extractStormlight(finalCost, false));
                    this.sendUpdate();
                }
            } else {
                Vec3 center = pPos.m_252807_();
                for (int i = 0; i < 30; ++i) {
                    double angle = Math.PI * 2 * ((double)i + Math.random()) / 30.0;
                    pLevel.m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT.get(), center.f_82479_, center.f_82480_, center.f_82481_, 0.5 * Math.cos(angle), 0.01 * (Math.random() * 2.0 - 1.0), 0.5 * Math.sin(angle));
                }
                pLevel.m_245747_(pPos, (SoundEvent)StormwardSoundEvents.CULTIVATOR.get(), SoundSource.BLOCKS, 1.0f, (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.05f + 1.0f, false);
            }
        }
    }
}

