/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.stormlightstorage;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.block.stormlightstorage.TransferenceConnectorBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.stormlightstorage.StormlightTransferBlockEntity;
import us.amon.stormward.blockentity.stormlightstorage.TransferenceConnectorEntity;
import us.amon.stormward.blockentity.stormlightstorage.TransferenceOutputEntity;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.particle.StormwardParticles;

public class TransferenceInputEntity
extends TransferenceConnectorEntity {
    public TransferenceInputEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.TRANSFERENCE_INPUT.get(), pPos, pBlockState);
    }

    public List<TransferenceOutputEntity> getReceivers() {
        ArrayList<TransferenceOutputEntity> receivers = new ArrayList<TransferenceOutputEntity>();
        if (this.m_58904_() != null) {
            for (BlockPos pos : this.connectorPositions) {
                TransferenceOutputEntity inputEntity;
                BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
                if (!(blockEntity instanceof TransferenceOutputEntity) || !(inputEntity = (TransferenceOutputEntity)blockEntity).canReceiveStormlight()) continue;
                receivers.add(inputEntity);
            }
        }
        return receivers;
    }

    @Override
    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_5776_() && (pLevel.m_46467_() + pPos.m_121878_()) % 10L == 0L) {
            boolean result = false;
            if (this.canExtractStormlight()) {
                List<TransferenceOutputEntity> receivers = this.getReceivers();
                StormlightTransferBlockEntity from = this.getConnectedEntity();
                for (TransferenceOutputEntity receiver : receivers) {
                    int amount = Mth.m_14167_((float)(6.0f / (float)Math.max(receivers.size(), receiver.getExtractors().size())));
                    StormlightTransferBlockEntity to = receiver.getConnectedEntity();
                    if (!StormlightStorageHelper.transfer((ICapabilityProvider)from, (ICapabilityProvider)to, amount)) continue;
                    receiver.setReceivedStormlight();
                    to.sendUpdate();
                    result = true;
                }
                if (result) {
                    from.sendUpdate();
                }
            }
            if (this.isActive != result) {
                this.isActive = result;
                this.sendUpdate(pLevel, pPos, pState);
            }
        }
        super.tick(pLevel, pPos, pState);
    }

    @Override
    protected void playActiveEffects(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_46467_() % 3L == 0L) {
            Direction facing = (Direction)pState.m_61143_((Property)TransferenceConnectorBlock.FACING);
            Vec3 pos = pPos.m_252807_().m_231075_(facing, 0.45);
            Vec3 offset = this.getRandomParticleOffset(pLevel, facing);
            pLevel.m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT_TRANSFER.get(), pos.f_82479_ + offset.f_82479_, pos.f_82480_ + offset.f_82480_, pos.f_82481_ + offset.f_82481_, -offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
        }
    }
}

