/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.blockentity.stormlightstorage;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import us.amon.stormward.block.stormlightstorage.TransferenceConnectorBlock;
import us.amon.stormward.blockentity.StormwardBlockEntities;
import us.amon.stormward.blockentity.stormlightstorage.TransferenceConnectorEntity;
import us.amon.stormward.blockentity.stormlightstorage.TransferenceInputEntity;
import us.amon.stormward.particle.StormwardParticles;

public class TransferenceOutputEntity
extends TransferenceConnectorEntity {
    protected boolean receivedSinceLastTick;

    public TransferenceOutputEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)StormwardBlockEntities.TRANSFERENCE_OUTPUT.get(), pPos, pBlockState);
    }

    public void setReceivedStormlight() {
        this.receivedSinceLastTick = true;
    }

    public List<TransferenceInputEntity> getExtractors() {
        ArrayList<TransferenceInputEntity> extractors = new ArrayList<TransferenceInputEntity>();
        if (this.m_58904_() != null) {
            for (BlockPos pos : this.connectorPositions) {
                TransferenceInputEntity outputEntity;
                BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
                if (!(blockEntity instanceof TransferenceInputEntity) || !(outputEntity = (TransferenceInputEntity)blockEntity).canExtractStormlight()) continue;
                extractors.add(outputEntity);
            }
        }
        return extractors;
    }

    @Override
    protected void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_5776_() && (pLevel.m_46467_() + pPos.m_121878_()) % 10L == 0L) {
            if (this.isActive != this.receivedSinceLastTick) {
                this.isActive = this.receivedSinceLastTick;
                this.sendUpdate(pLevel, pPos, pState);
            }
            this.receivedSinceLastTick = false;
        }
        super.tick(pLevel, pPos, pState);
    }

    @Override
    protected void playActiveEffects(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_46467_() % 3L == 0L) {
            Direction facing = (Direction)pState.m_61143_((Property)TransferenceConnectorBlock.FACING);
            Vec3 pos = pPos.m_252807_().m_231075_(facing, 0.45);
            Vec3 offset = this.getRandomParticleOffset(pLevel, facing);
            pLevel.m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT_TRANSFER.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, offset.f_82479_, offset.f_82480_, offset.f_82481_);
        }
    }
}

