/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability.shardstorage;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import us.amon.stormward.capability.shardstorage.IShardStorage;

public class ShardStorage
implements IShardStorage {
    private final List<Pair<Integer, ItemStack>> shards = new ArrayList<Pair<Integer, ItemStack>>();
    private BlockPos portalPos;
    private ResourceLocation portalDimension;

    @Override
    public void setPortalInfo(BlockPos pPos, ResourceLocation pDimension) {
        this.portalPos = pPos;
        this.portalDimension = pDimension;
    }

    @Override
    public void clearPortalInfo() {
        this.portalPos = null;
        this.portalDimension = null;
    }

    @Override
    public BlockPos getPortalPos() {
        return this.portalPos;
    }

    @Override
    public ResourceLocation getPortalDimension() {
        return this.portalDimension;
    }

    @Override
    public void receiveShard(int pSlotId, ItemStack pStack) {
        this.shards.add((Pair<Integer, ItemStack>)new Pair((Object)pSlotId, (Object)pStack.m_278832_()));
    }

    @Override
    public boolean hasShards() {
        return !this.shards.isEmpty();
    }

    @Override
    public List<ItemStack> getShards() {
        return this.shards.stream().map(Pair::getSecond).toList();
    }

    @Override
    public List<Pair<Integer, ItemStack>> extractShards() {
        ArrayList<Pair<Integer, ItemStack>> copy = new ArrayList<Pair<Integer, ItemStack>>(this.shards);
        this.shards.clear();
        return copy;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag shardList = new ListTag();
        for (Pair<Integer, ItemStack> shard : this.shards) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", ((Integer)shard.getFirst()).intValue());
            ((ItemStack)shard.getSecond()).m_41739_(itemTag);
            shardList.add((Object)itemTag);
        }
        nbt.m_128365_("Shards", (Tag)shardList);
        if (this.getPortalPos() != null) {
            nbt.m_128365_("PortalPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getPortalPos()));
        }
        if (this.getPortalDimension() != null) {
            nbt.m_128359_("PortalDimension", this.getPortalDimension().toString());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.shards.clear();
        ListTag shardList = nbt.m_128437_("Shards", 10);
        for (int i = 0; i < shardList.size(); ++i) {
            CompoundTag itemTag = shardList.m_128728_(i);
            int slot = itemTag.m_128451_("Slot");
            this.receiveShard(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
        BlockPos portalPos = nbt.m_128441_("PortalPos") ? NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("PortalPos")) : null;
        ResourceLocation portalDimension = nbt.m_128441_("PortalDimension") ? new ResourceLocation(nbt.m_128461_("PortalDimension")) : null;
        this.setPortalInfo(portalPos, portalDimension);
    }
}

