/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability.shardstorage;

import com.mojang.datafixers.util.Pair;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.shardstorage.IShardStorage;
import us.amon.stormward.entity.shardbearer.Shardbearer;
import us.amon.stormward.item.shard.IShardItem;
import us.amon.stormward.worldgen.dimension.StormwardDimensions;

public class ShardStorageHelper {
    public static boolean shouldStoreShards(Level pLevel) {
        return pLevel.m_46472_() == StormwardDimensions.SHADESMAR_DIMENSION;
    }

    public static void tickShardStorage(Level pLevel, Entity pEntity, ItemStack pStack, int pSlotId) {
        if (ShardStorageHelper.shouldStoreShards(pLevel)) {
            ShardStorageHelper.storeShard(pEntity, pStack, pSlotId);
        }
    }

    public static void tickShardStorage(LivingEntity pEntity) {
        if (ShardStorageHelper.shouldStoreShards(pEntity.m_9236_())) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = pEntity.m_6844_(slot);
                if (!(stack.m_41720_() instanceof IShardItem)) continue;
                ShardStorageHelper.storeShard((Entity)pEntity, stack, slot);
            }
        }
    }

    public static void storeShard(Entity pEntity, ItemStack pStack, int pSlotId) {
        pEntity.getCapability(StormwardCapabilities.SHARD_STORAGE).ifPresent(shards -> {
            ShardStorageHelper.onShardStored(pEntity, pStack);
            shards.receiveShard(pSlotId, pStack);
        });
    }

    public static void storeShard(Entity pEntity, ItemStack pStack, EquipmentSlot pSlot) {
        pEntity.getCapability(StormwardCapabilities.SHARD_STORAGE).ifPresent(shards -> {
            ShardStorageHelper.onShardStored(pEntity, pStack);
            shards.receiveShard(pSlot, pStack);
        });
    }

    private static void returnShards(Entity pEntity, BiConsumer<Integer, ItemStack> pConsumer) {
        pEntity.getCapability(StormwardCapabilities.SHARD_STORAGE).ifPresent(shards -> {
            for (Pair<Integer, ItemStack> shard : shards.extractShards()) {
                ItemStack stack = (ItemStack)shard.getSecond();
                ShardStorageHelper.onShardReturned(pEntity, stack);
                if (stack.m_41619_()) continue;
                pConsumer.accept((Integer)shard.getFirst(), stack);
            }
        });
    }

    public static void returnShards(Player pPlayer) {
        Inventory inventory = pPlayer.m_150109_();
        ShardStorageHelper.returnShards((Entity)pPlayer, (slot, stack) -> {
            ItemEntity itemEntity;
            if (inventory.m_8020_(slot.intValue()).m_41619_()) {
                inventory.m_6836_(slot.intValue(), stack);
            } else if (!inventory.m_36054_(stack) && (itemEntity = pPlayer.m_36176_(stack, false)) != null) {
                itemEntity.m_32061_();
                itemEntity.m_266426_(pPlayer.m_20148_());
            }
        });
    }

    public static void returnShards(Shardbearer pShardbearer) {
        ShardStorageHelper.returnShards((Entity)pShardbearer, (slot, stack) -> {
            EquipmentSlot equipmentSlot = ShardStorageHelper.byFilterFlag(slot);
            if (!pShardbearer.m_21033_(equipmentSlot)) {
                pShardbearer.m_8061_(equipmentSlot, (ItemStack)stack);
            } else {
                ShardStorageHelper.drop((Entity)pShardbearer, stack);
            }
        });
    }

    private static void onShardStored(Entity pEntity, ItemStack pStack) {
        Item item = pStack.m_41720_();
        if (item instanceof IShardItem) {
            IShardItem shardItem = (IShardItem)item;
            shardItem.onShardStored(pEntity, pStack);
        }
    }

    private static void onShardReturned(Entity pEntity, ItemStack pStack) {
        Item item = pStack.m_41720_();
        if (item instanceof IShardItem) {
            IShardItem shardItem = (IShardItem)item;
            shardItem.onShardReturned(pEntity, pStack);
        }
    }

    private static EquipmentSlot byFilterFlag(int pFilterFlag) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20750_() != pFilterFlag) continue;
            return slot;
        }
        return EquipmentSlot.MAINHAND;
    }

    private static void drop(Entity pTarget, ItemStack pStack) {
        ShardStorageHelper.drop(pTarget.m_9236_(), pTarget.m_20182_(), pStack);
    }

    private static void drop(Level pLevel, Vec3 pPos, ItemStack pStack) {
        if (!pStack.m_41619_() && !pLevel.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(pLevel, pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, pStack);
            itemEntity.m_32061_();
            float angle = pLevel.f_46441_.m_188501_() * ((float)Math.PI * 2);
            float radius = 0.05f * pLevel.f_46441_.m_188501_();
            itemEntity.m_20334_(Math.cos(angle) * (double)radius, (double)((pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.1f), Math.sin(angle) * (double)radius);
            pLevel.m_7967_((Entity)itemEntity);
        }
    }

    public static void clearPortalInfo(Entity pEntity) {
        pEntity.getCapability(StormwardCapabilities.SHARD_STORAGE).ifPresent(IShardStorage::clearPortalInfo);
    }

    public static void onEntityTravelToDimension(Entity pEntity, ResourceKey<Level> pDimension) {
        Level level = pEntity.m_9236_();
        if (!level.f_46443_) {
            if (pDimension == StormwardDimensions.SHADESMAR_DIMENSION) {
                pEntity.getCapability(StormwardCapabilities.SHARD_STORAGE).ifPresent(shards -> shards.setPortalInfo(pEntity.m_20183_(), (ResourceKey<Level>)level.m_46472_()));
            } else if (level.m_46472_() == StormwardDimensions.SHADESMAR_DIMENSION) {
                if (pEntity instanceof Player) {
                    Player player = (Player)pEntity;
                    ShardStorageHelper.returnShards(player);
                } else if (pEntity instanceof Shardbearer) {
                    Shardbearer shardbearer = (Shardbearer)pEntity;
                    ShardStorageHelper.returnShards(shardbearer);
                }
                ShardStorageHelper.clearPortalInfo(pEntity);
            }
        }
    }

    public static void onLivingDeath(LivingEntity pEntity) {
        Level level = pEntity.m_9236_();
        if (!level.f_46443_) {
            pEntity.getCapability(StormwardCapabilities.SHARD_STORAGE).ifPresent(shards -> {
                if (shards.hasShards() && (!level.m_46469_().m_46207_(GameRules.f_46133_) || pEntity.m_6095_() != EntityType.f_20532_) && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    MinecraftServer server = serverLevel.m_7654_();
                    for (ResourceKey key : server.m_129784_()) {
                        if (!key.m_135782_().equals((Object)shards.getPortalDimension())) continue;
                        ServerLevel destination = server.m_129880_(key);
                        Vec3 pos = shards.getPortalPos().m_252807_();
                        for (Pair<Integer, ItemStack> shard : shards.extractShards()) {
                            ItemStack stack = (ItemStack)shard.getSecond();
                            ShardStorageHelper.onShardReturned((Entity)pEntity, stack);
                            ShardStorageHelper.drop((Level)destination, pos, stack);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerRespawn(Player pPlayer) {
        Level level = pPlayer.m_9236_();
        if (!level.f_46443_ && level.m_46472_() != StormwardDimensions.SHADESMAR_DIMENSION) {
            ShardStorageHelper.returnShards(pPlayer);
            ShardStorageHelper.clearPortalInfo((Entity)pPlayer);
        }
    }
}

