/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability.stormlightstorage;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;

public class StormlightItemHandlerStorage
implements IStormlightStorage {
    ICapabilityProvider provider;

    public StormlightItemHandlerStorage(ICapabilityProvider pProvider) {
        this.provider = pProvider;
    }

    @Override
    public int receiveStormlight(int pAmount, boolean pSimulate) {
        return this.provider.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            int received = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                int remaining = Math.max(0, pAmount - received);
                received += itemHandler.getStackInSlot(i).getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> stormlightStorage.receiveStormlight(remaining, pSimulate)).orElse(0).intValue();
            }
            return received;
        }).orElse(0);
    }

    @Override
    public int receiveHighstorm(boolean pSimulate) {
        return this.provider.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            int received = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                received += itemHandler.getStackInSlot(i).getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> stormlightStorage.receiveHighstorm(pSimulate)).orElse(0).intValue();
            }
            return received;
        }).orElse(0);
    }

    @Override
    public int extractStormlight(int pAmount, boolean pSimulate) {
        return this.provider.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            int extracted = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                extracted = Math.max(extracted, itemHandler.getStackInSlot(i).getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> stormlightStorage.extractStormlight(pAmount, pSimulate)).orElse(0));
            }
            return extracted;
        }).orElse(0);
    }

    @Override
    public void copy(ICapabilityProvider pOther) {
        pOther.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(otherStorage -> this.setStormlight(otherStorage.getStormlight()));
    }

    @Override
    public void setStormlight(int pValue) {
        this.provider.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                itemHandler.getStackInSlot(i).getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> stormlightStorage.setStormlight(pValue));
            }
        });
    }

    @Override
    public int getStormlight() {
        return this.provider.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            int stormlight = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                stormlight += itemHandler.getStackInSlot(i).getCapability(StormwardCapabilities.STORMLIGHT).map(IStormlightStorage::getStormlight).orElse(0).intValue();
            }
            return stormlight;
        }).orElse(0);
    }

    @Override
    public int getMaxStormlight() {
        return this.provider.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> {
            int maxStormlight = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                maxStormlight += itemHandler.getStackInSlot(i).getCapability(StormwardCapabilities.STORMLIGHT).map(IStormlightStorage::getMaxStormlight).orElse(0).intValue();
            }
            return maxStormlight;
        }).orElse(0);
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }
}

