/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability.stormlightstorage;

import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import us.amon.stormward.blockentity.stormlightstorage.StormlightStorageBlockEntity;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.IStormlightStorage;
import us.amon.stormward.weather.Highstorm;

public class StormlightStorageHelper {
    public static final int HIGHSTORM_INTERVAL = 20;

    public static boolean shouldReceiveHighstormStormlight(Entity entity) {
        return entity.f_19797_ % 20 == 0 && Highstorm.isEntityExposedToHighstorm(entity);
    }

    public static void updateEntityStormlight(LivingEntity entity) {
        if (!entity.m_9236_().f_46443_ && StormlightStorageHelper.shouldReceiveHighstormStormlight((Entity)entity)) {
            StormlightStorageHelper.receiveHighstormProvider((ICapabilityProvider)entity.m_6844_(EquipmentSlot.MAINHAND));
            StormlightStorageHelper.receiveHighstormProvider((ICapabilityProvider)entity.m_6844_(EquipmentSlot.OFFHAND));
        }
    }

    public static boolean shouldReceiveHighstormStormlight(StormlightStorageBlockEntity entity) {
        return entity.m_58898_() && entity.m_58904_().m_46467_() % 20L == 0L && entity.isExposedToHighstorm();
    }

    public static boolean receiveHighstormProvider(ICapabilityProvider provider) {
        return provider.getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> stormlightStorage.isDun() & stormlightStorage.receiveHighstorm(false) > 0).orElse(false);
    }

    public static boolean transfer(ICapabilityProvider from, ICapabilityProvider to, int amount) {
        return to.getCapability(StormwardCapabilities.STORMLIGHT).map(toStormlightStorage -> {
            int max = toStormlightStorage.receiveStormlight(amount, true);
            int extracted = from.getCapability(StormwardCapabilities.STORMLIGHT).map(fromStormlightStorage -> fromStormlightStorage.extractStormlight(max, false)).orElse(0);
            return toStormlightStorage.receiveStormlight(extracted, false) > 0;
        }).orElse(false);
    }

    public static void setFull(ICapabilityProvider provider) {
        provider.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> stormlightStorage.setStormlight(stormlightStorage.getMaxStormlight()));
    }

    public static void setFull(Ingredient ingredient) {
        for (ItemStack stack : ingredient.m_43908_()) {
            StormlightStorageHelper.setFull((ICapabilityProvider)stack);
        }
    }

    public static void setFull(List<Ingredient> ingredients) {
        for (Ingredient ingredient : ingredients) {
            StormlightStorageHelper.setFull(ingredient);
        }
    }

    public static void setFromContainerAverage(ICapabilityProvider provider, Container container) {
        provider.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> {
            float totalPercent = 0.0f;
            float num = 0.0f;
            for (int i = 0; i < container.m_6643_(); ++i) {
                float percent = container.m_8020_(i).getCapability(StormwardCapabilities.STORMLIGHT).map(containerStorage -> Float.valueOf((float)containerStorage.getStormlight() / (float)containerStorage.getMaxStormlight())).orElse(Float.valueOf(0.0f)).floatValue();
                if (!(percent > 0.0f)) continue;
                totalPercent += percent;
                num += 1.0f;
            }
            stormlightStorage.setStormlight((int)((float)stormlightStorage.getMaxStormlight() * totalPercent / num));
        });
    }

    public static boolean hasStormlightStorage(ICapabilityProvider provider) {
        return provider.getCapability(StormwardCapabilities.STORMLIGHT).isPresent();
    }

    public static int getStormlight(ICapabilityProvider provider) {
        return provider.getCapability(StormwardCapabilities.STORMLIGHT).map(IStormlightStorage::getStormlight).orElse(0);
    }

    public static int getMaxStormlight(ICapabilityProvider provider) {
        return provider.getCapability(StormwardCapabilities.STORMLIGHT).map(IStormlightStorage::getMaxStormlight).orElse(0);
    }

    public static boolean isDun(ICapabilityProvider provider) {
        return provider.getCapability(StormwardCapabilities.STORMLIGHT).map(IStormlightStorage::isDun).orElse(true);
    }

    public static boolean isFull(ICapabilityProvider provider) {
        return provider.getCapability(StormwardCapabilities.STORMLIGHT).map(IStormlightStorage::isFull).orElse(false);
    }
}

