/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.capability.tusks;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.VanillaGameEvent;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.tusks.ITusks;
import us.amon.stormward.effect.StormwardEffects;
import us.amon.stormward.entity.Whitespine;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.network.ClientboundTuskPacket;
import us.amon.stormward.network.PacketHandler;
import us.amon.stormward.sound.StormwardSoundEvents;

public class TusksHelper {
    private static final int IMPALE_TICKS = 200;

    public static void impale(Whitespine pWhitespine, ServerPlayer pPlayer) {
        pPlayer.getCapability(StormwardCapabilities.TUSKS).ifPresent(tusks -> {
            tusks.addTusk();
            PacketHandler.sendToPlayer(new ClientboundTuskPacket(tusks.getTusks()), pPlayer);
        });
        MobEffectInstance effect = pPlayer.m_21124_((MobEffect)StormwardEffects.IMPALED.get());
        int amplifier = 0;
        if (effect != null) {
            amplifier += 1 + effect.m_19564_();
            pPlayer.m_6234_((MobEffect)StormwardEffects.IMPALED.get());
        }
        amplifier = Mth.m_14045_((int)amplifier, (int)0, (int)4);
        pPlayer.m_7292_(new MobEffectInstance((MobEffect)StormwardEffects.IMPALED.get(), 200, amplifier));
        pWhitespine.setTusks(pWhitespine.getTusks() - 1);
        pWhitespine.m_5496_((SoundEvent)StormwardSoundEvents.WHITESPINE_TUSK_BREAK.get(), 1.0f, pWhitespine.m_6100_());
    }

    public static void update(ServerPlayer pPlayer) {
        pPlayer.getCapability(StormwardCapabilities.TUSKS).ifPresent(tusks -> PacketHandler.sendToPlayer(new ClientboundTuskPacket(tusks.getTusks()), pPlayer));
    }

    public static void onLivingEntityTick(LivingEntity pEntity) {
        if (!pEntity.m_9236_().f_46443_ && pEntity.m_6095_() == EntityType.f_20532_) {
            pEntity.getCapability(StormwardCapabilities.TUSKS).ifPresent(tusks -> {
                if (tusks.getTusks() > 0 && pEntity.m_21124_((MobEffect)StormwardEffects.IMPALED.get()) == null) {
                    TusksHelper.popTusks((Entity)pEntity, tusks);
                }
            });
        }
    }

    public static void onVanillaGameEvent(VanillaGameEvent event) {
        if (event.getVanillaEvent() == GameEvent.f_223707_) {
            event.getCause().getCapability(StormwardCapabilities.TUSKS).ifPresent(tusks -> TusksHelper.popTusks(event.getCause(), tusks));
        }
    }

    private static void popTusks(Entity pEntity, ITusks tusks) {
        for (int i = 0; i < tusks.getTusks(); ++i) {
            ItemEntity itementity = new ItemEntity(pEntity.m_9236_(), pEntity.m_20185_(), pEntity.m_20227_(0.5), pEntity.m_20189_(), new ItemStack((ItemLike)StormwardItems.WHITESPINE_TUSK.get()));
            itementity.m_32060_();
            pEntity.m_9236_().m_7967_((Entity)itementity);
        }
        tusks.clearTusks();
        PacketHandler.sendToPlayer(new ClientboundTuskPacket(tusks.getTusks()), (ServerPlayer)pEntity);
    }
}

