/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import org.jetbrains.annotations.NotNull;

public class FormatStructureElementCommand {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        if (ForgeGameTestHooks.isGametestEnabled()) {
            pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"format_structure_element").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(stack -> FormatStructureElementCommand.formatStructureElement((CommandSourceStack)stack.getSource(), BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_((CommandContext)stack, (String)"from"), (Vec3i)BlockPosArgument.m_118242_((CommandContext)stack, (String)"to")))))));
        }
    }

    private static int formatStructureElement(CommandSourceStack pSource, BoundingBox pArea) {
        ServerLevel level = pSource.m_81372_();
        ServerPlayer player = pSource.m_230896_();
        HashMap<String, Character> states = new HashMap<String, Character>();
        char[][][] shape = new char[pArea.m_71057_()][pArea.m_71058_()][pArea.m_71056_()];
        int charIndex = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < pArea.m_71057_(); ++y) {
            for (int z = 0; z < pArea.m_71058_(); ++z) {
                for (int x = 0; x < pArea.m_71056_(); ++x) {
                    pos.m_122178_(pArea.m_162395_() + x, pArea.m_162400_() - y, pArea.m_162398_() + z);
                    BlockState state = level.m_8055_((BlockPos)pos);
                    if (!state.m_60795_()) {
                        String str = BlockStateParser.m_116769_((BlockState)state);
                        if (states.containsKey(str)) {
                            shape[y][z][x] = ((Character)states.get(str)).charValue();
                            continue;
                        }
                        char val = (char)(35 + charIndex++);
                        states.put(str, Character.valueOf(val));
                        shape[y][z][x] = val;
                        continue;
                    }
                    shape[y][z][x] = 32;
                }
            }
        }
        if (player != null) {
            String output = FormatStructureElementCommand.getOutput(states, shape);
            ClickEvent event = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, output);
            MutableComponent component = Component.m_237113_((String)"Click to copy structure element output").m_130948_(Style.f_131099_.m_131142_(event));
            player.m_240418_((Component)component, false);
        }
        return 1;
    }

    @NotNull
    private static String getOutput(Map<String, Character> pStates, char[][][] pShape) {
        JsonObject statesJson = new JsonObject();
        for (Map.Entry<String, Character> entry : pStates.entrySet()) {
            statesJson.addProperty(entry.getValue().toString(), entry.getKey());
        }
        JsonArray shapeJson = new JsonArray(pShape.length);
        for (char[][] slice : pShape) {
            JsonArray sliceJson = new JsonArray(slice.length);
            for (char[] row : slice) {
                sliceJson.add(new String(row));
            }
            shapeJson.add((JsonElement)sliceJson);
        }
        return "{\n\t\"states\": " + statesJson + ",\n\t\"shape\": " + shapeJson + "\n}";
    }
}

